using System;
using System.IO;
using System.Threading;
using Selenium;
using NUnit.Framework;
using Orciid.Core;

namespace webtests
{
	[TestFixture]
	[Category("UsesSelenium")]
	public class InvalidFavoriteImage: SeleniumTestFixture
	{
		[Test]
		public void TestInvalidFavoriteImage() 
		{
			LoginAdministrator(selenium);
			selenium.Click("link=My Favorites");
			selenium.WaitForPageToLoad("30000");
			Assert.AreEqual("Search Results", selenium.GetText("//h1[@id='Title']"));
		}

//		private SqlDbUnitTest dbu;
		private Utilities util;

		protected override void MoreSetUp()
		{
			// current directory should be webtests/bin/Debug
			string dsdir = Path.Combine(Directory.GetCurrentDirectory(), @"..\..\datasets");

			util = new Utilities(dsdir);
//			dbu = new SqlDbUnitTest(util.Connection);

			// prepare invalid FavoriteImages record
//			dbu.ReadXmlSchema(Path.Combine(dsdir, "OrciidDataset.xsd"));
//			dbu.ReadXml(Path.Combine(dsdir, "InvalidFavoriteImages.xml"));


/*
	 <?xml version="1.0" standalone="yes"?>
<!-- edited with XMLSPY v5 rel. 4 U (http://www.xmlspy.com) by Andreas Knab (James Madison University) -->
<InvalidFavoriteImagesDataset xmlns="http://tempuri.org/OrciidDataset.xsd">
	<!-- Insert an invalid favorite image record in the database -->
	<FavoriteImages>
		<UserID>1</UserID>
		<ImageID>12345</ImageID>
		<CollectionID>4321</CollectionID>
	</FavoriteImages>
	<!-- Insert a valid favorite image record in the database -->
	<FavoriteImages>
		<UserID>1</UserID>
		<ImageID>1</ImageID>
		<CollectionID>1</CollectionID>
	</FavoriteImages>
	<Images>
		<ID>1</ID>
		<CollectionID>1</CollectionID>
		<Resource>test.jpg</Resource>
	</Images>
	<FieldData>
		<ID>1</ID>
		<ImageID>1</ImageID>
		<CollectionID>1</CollectionID>
		<FieldID>1</FieldID>
		<FieldInstance>0</FieldInstance>
		<FieldValue>Test Image</FieldValue>
	</FieldData>
</InvalidFavoriteImagesDataset>
*/

			// insert invalid record
//			dbu.PerformDbOperation(DbOperationFlag.Refresh);

			using (DBConnection conn = DBConnector.GetConnection(true))
			{
				conn.ExecQuery(new Query(conn, 
					"INSERT INTO FavoriteImages (UserID,ImageID,CollectionID) " +
					"VALUES (1, 123456, 123456)"));
			}
		}

		protected override void MoreTearDown()
		{			
			// remove invalid record
			//dbu.PerformDbOperation(DbOperationFlag.Delete);

			using (DBConnection conn = DBConnector.GetConnection(true))
			{
				conn.ExecQuery(new Query(conn, 
					"DELETE FROM FavoriteImages WHERE UserID=1 AND " +
					"ImageID=123456 AND CollectionID=123456"));
			}
		}
	}
}
