using System;
using System.Collections;
using System.IO;
using System.Data;
using System.Data.SqlClient;
using NUnit.Framework;
using Orciid.Core;

namespace webtests
{
	[TestFixture]
	public class TestFieldMappingMemory
	{
		private ArrayList collections = new ArrayList();
		private Utilities util;

		[SetUp]
		protected void SetUp()
		{
			// current directory should be webtests/bin/Debug
			string dsdir = Path.Combine(Directory.GetCurrentDirectory(), @"..\..\datasets");

			util = new Utilities(dsdir);

			User.GetByLogin("admin", "admin").Activate(null);
		}

		[TearDown]
		protected void TearDown()
		{
			foreach (Collection c in collections)
				if (c != null)
					c.Delete();
		}

		private Collection GetTempCollection()
		{
			Collection coll = new Collection();
			coll.Title = "temp_" + Guid.NewGuid().ToString();
			coll.Description = coll.Title;
			coll.ResourcePath = @"\\invalid\resourcepath";
			coll.Update();
			collections.Add(coll);
			return coll;
		}

		[Test]
		public void TestMappingPersistence()
		{
			Collection coll = GetTempCollection();
			coll.CreateDublinCoreFields();

			string[] source1 = new string[] { "A", "B", "C", "X", "Y", "Z" };
			string[] source2 = new string[] { "D", "E", "F", "X", "Y", "Z" };

			DataTable table1 = new DataTable();
			foreach (string s in source1)
				table1.Columns.Add(s);
			DataTable table2 = new DataTable();
			foreach (string s in source2)
				table2.Columns.Add(s);


			FieldMapping mapping1 = new FieldMapping(table1, coll);
			Assert.IsNull(mapping1.GetMapping("A"));
			Assert.IsNull(mapping1.GetMapping("B"));
			Assert.IsNull(mapping1.GetMapping("C"));
			Assert.IsNull(mapping1.GetMapping("X"));
			Assert.IsNull(mapping1.GetMapping("Y"));
			mapping1.AddMapping("A", "Title");
			mapping1.AddMapping("B", "Creator");
			mapping1.AddMapping("C", "Subject");
			mapping1.AddMapping("X", "Identifier");
			mapping1.AddMapping("Y", "Rights");
			mapping1.Remember();
			mapping1 = null;

			FieldMapping mapping2 = new FieldMapping(table2, coll);
			Assert.IsNull(mapping2.GetMapping("D"));
			Assert.IsNull(mapping2.GetMapping("E"));
			Assert.IsNull(mapping2.GetMapping("F"));
			Assert.AreEqual("Identifier", mapping2.GetMapping("X"));
			Assert.AreEqual("Rights", mapping2.GetMapping("Y"));
			mapping2.AddMapping("D", "Title");
			mapping2.AddMapping("E", "Creator");
			mapping2.AddMapping("F", "Subject");
			mapping2.AddMapping("X", "Identifier");
			mapping2.AddMapping("Y", "Publisher");
			mapping2.Remember();
			mapping2 = null;

			FieldMapping mapping3 = new FieldMapping(table1, coll);
			Assert.AreEqual("Title", mapping3.GetMapping("A"));
			Assert.AreEqual("Creator", mapping3.GetMapping("B"));
			Assert.AreEqual("Subject", mapping3.GetMapping("C"));
			Assert.AreEqual("Identifier", mapping3.GetMapping("X"));
			Assert.AreEqual("Rights", mapping3.GetMapping("Y"));

			FieldMapping mapping4 = new FieldMapping(table2, coll);
			Assert.AreEqual("Title", mapping4.GetMapping("D"));
			Assert.AreEqual("Creator", mapping4.GetMapping("E"));
			Assert.AreEqual("Subject", mapping4.GetMapping("F"));
			Assert.AreEqual("Identifier", mapping4.GetMapping("X"));
			Assert.AreEqual("Publisher", mapping4.GetMapping("Y"));
		}
	}
}
