using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Collections;
using System.Diagnostics;
using System.Globalization;
using System.Resources;
using System.IO;
using System.Threading;
using System.Text.RegularExpressions;
using Orciid.Core;

namespace Orciid.PageTemplate
{

	public class LocalPage: System.Web.UI.Page
	{
		private CultureInfo cultureinfo;
		private ResourceManager resourcemanager; 

		public LocalPage()
		{
		
		}

		protected void LanguageChanged()
		{
			string language = Session["Language"] as string;
			if (language == null || language.Length == 0)
				language = "en-US";
			cultureinfo = new CultureInfo(language); 
			Thread.CurrentThread.CurrentCulture = cultureinfo;
			resourcemanager = ResourceManager.CreateFileBasedResourceManager("orciid",
				Server.MapPath("~/PageTemplate"), null);
			Response.Cookies.Add(new HttpCookie("lang", language));
		}

		override protected void OnInit(EventArgs e)
		{
			if (Session["Language"] == null)
			{
				HttpCookie languagecookie = Request.Cookies["lang"];
				if (languagecookie != null)
					Session["Language"] = languagecookie.Value;
			}
			LanguageChanged();
			base.OnInit(e);
		}

		protected void Localize()
		{
			Localize(this, Path.GetFileNameWithoutExtension(
				Page.Request.CurrentExecutionFilePath).ToLower());			
		}

		private void Localize(Control parent, string prefix)
		{
			if (parent is UserControl)
			{
				string parenttype = parent.GetType().ToString().ToLower();
				if (parenttype.StartsWith("asp.") && parenttype.EndsWith("_ascx"))
				{
					string ucprefix = "_" + parenttype.Substring(4, parenttype.Length - 9);
					foreach (Control child in parent.Controls)
						Localize(child, ucprefix);
				}
			}
			if (parent.ID != null && parent.ID.Length > 0)
			{
				String s = resourcemanager.GetString(prefix + "_" + parent.ID, cultureinfo);
				if (s != null)
				{
					if (parent is HtmlContainerControl)
						((HtmlContainerControl)parent).InnerText = s;
					else if (parent is Label)
						((Label)parent).Text = s;
					else if (parent is Button)
						((Button)parent).Text = s;
					else if (parent is LinkButton)
						((LinkButton)parent).Text = s;
					else if (parent is HyperLink)
						((HyperLink)parent).Text = s;
					else if (parent is CheckBox)
						((CheckBox)parent).Text = s;
				}
			}
			if (parent.HasControls())
				foreach (Control child in parent.Controls)
					Localize(child, prefix);
		}

		public string GetLocalString(Control control, string id, string def)
		{
			string prefix = null;
			if (control == null)
			{
				prefix = "";
			}
			else if (control is UserControl)
			{
				string parenttype = control.GetType().ToString().ToLower();
				if (parenttype.StartsWith("asp.") && parenttype.EndsWith("_ascx"))
					prefix = "_" + parenttype.Substring(4, parenttype.Length - 9);
			}
			else if (control is Page)
			{
				prefix = Path.GetFileNameWithoutExtension(
					((Page)control).Request.CurrentExecutionFilePath);
			}

			if (prefix != null)
			{
				string s = resourcemanager.GetString(prefix + "_" + id, cultureinfo);
				return (s != null ? s : def);
			}
			else 
				return def;
		}

		public string GetPrivilegeLabel(Privilege p)
		{
			string id = "Privilege_" + p.ToString();
			return GetLocalString(null, id, p.ToString());
		}

		public string GetCollectionTypeLabel(CollectionType type)
		{
			string id = "CollectionType_" + type.ToString();
			return GetLocalString(null, id, type.ToString());
		}

		public override void Dispose()
		{
#if DEBUG
			if (resourcemanager != null)
				resourcemanager.ReleaseAllResources();
#endif
			base.Dispose ();
		}

	}
}
