namespace Orciid.PageTemplate
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using Orciid.Core;

	public abstract class PageMenu : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Literal HighlightedMenuItem;
		protected System.Web.UI.HtmlControls.HtmlTable LeftMenu;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID_Slideshows;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID_Favorites;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID_PersonalCollection;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID_Options;
		protected System.Web.UI.HtmlControls.HtmlTableRow MyMDID_Footer;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_Slideshows;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_Browse;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_Search;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_Downloads;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_CollectionOverview;
		protected System.Web.UI.HtmlControls.HtmlTableRow Resources_Footer;
		protected System.Web.UI.HtmlControls.HtmlTableRow Information;
		protected System.Web.UI.HtmlControls.HtmlTableRow Information_Announcements;
		protected System.Web.UI.HtmlControls.HtmlTableRow Information_About;
		protected System.Web.UI.HtmlControls.HtmlTableRow Information_Footer;
		protected System.Web.UI.WebControls.LinkButton MyMDID_Slideshows_Button;
		protected System.Web.UI.WebControls.LinkButton MyMDID_Favorites_Button;
		protected System.Web.UI.WebControls.LinkButton MyMDID_PersonalCollection_Button;
		protected System.Web.UI.WebControls.LinkButton MyMDID_Options_Button;
		protected System.Web.UI.WebControls.LinkButton Resources_Slideshows_Button;
		protected System.Web.UI.WebControls.LinkButton Resources_Browse_Button;
		protected System.Web.UI.WebControls.LinkButton Resources_Search_Button;
		protected System.Web.UI.WebControls.LinkButton Resources_Downloads_Button;
		protected System.Web.UI.WebControls.LinkButton Resources_CollectionOverview_Button;
		protected System.Web.UI.WebControls.LinkButton Information_Announcements_Button;
		protected System.Web.UI.WebControls.LinkButton Management_Collections_Button;
		protected System.Web.UI.WebControls.LinkButton Management_Users_Button;
		protected System.Web.UI.WebControls.LinkButton Management_Settings_Button;
		protected System.Web.UI.WebControls.LinkButton Management_TransactionLog_Button;
		protected System.Web.UI.WebControls.LinkButton Management_BackgroundTasks_Button;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_Collections;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_Users;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_Settings;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_TransactionLog;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_Footer;
		protected System.Web.UI.HtmlControls.HtmlTableRow Management_BackgroundTasks;
		protected System.Web.UI.HtmlControls.HtmlGenericControl MyMDID_Header;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Resources_Header;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Management_Header;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Information_Header;
		protected System.Web.UI.WebControls.LinkButton Information_About_Button;

		private void AddMouseOverCode(LinkButton button)
		{
			if (button.ID.EndsWith("_Button"))
			{
				string name = button.ID.Substring(0, button.ID.Length - 7);
				button.Attributes["onmouseover"] = String.Format("menuarrow_show('{0}_Arrow');", name);
				button.Attributes["onmouseout"] = String.Format("menuarrow_hide('{0}_Arrow');", name);
			}
		}
		
		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		private void HideInaccessibleMenuItems()
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();

			if (user == null)
			{
				// nobody is logged in, hide everything but information group
				HideMenuItem("MyMDID");
				HideMenuItem("Resources");
				HideMenuItem("Management");
			}
			else
			{
				if (user.ID < 0 || !Orciid.Core.User.HasPrivilege(Privilege.UserOptions))
				{
					// No Options for anyone not logged in
					HideMenuItem("MyMDID_Options");
				}
				
				// check privileges for individual items
				
				if (!Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.ReadCollection))
				{
					HideMenuItem("MyMDID_Favorites");
					HideMenuItem("Resources_Browse");
					HideMenuItem("Resources_Search");
					HideMenuItem("Resources_CollectionOverview");
				}

				if (!((PageTemplate.OrciidPage)Page).UserCanBuildSlideshows)
//				if (!Orciid.Core.User.HasPrivilege(Privilege.CreateSlideshow, user) &&
//					!Orciid.Core.User.HasPrivilegeOnAny('S', user, Privilege.ModifySlideshow, 
//						Privilege.DeleteSlideshow, Privilege.PackageImages, Privilege.ModifyACL))
				{
					HideMenuItem("MyMDID_Slideshows");
				}

				if (!Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.PersonalImages))
				{
					HideMenuItem("MyMDID_PersonalCollection");
				}

				FavoritesCollection fc = FavoritesCollection.GetFavoritesCollection();
				if (fc == null || !Orciid.Core.User.HasPrivilege(Privilege.ReadCollection, fc, user))
				{
					HideMenuItem("MyMDID_Favorites");
				}

				if (!Orciid.Core.User.HasPrivilegeOnAny('S', user, 
						Privilege.ViewSlideshow, Privilege.ModifySlideshow, Privilege.CopySlideshow) &&
					!Orciid.Core.User.HasPrivilege(Privilege.CreateSlideshow, user))
				{
					HideMenuItem("Resources_Slideshows");
				}

				if (!Orciid.Core.User.HasPrivilege(Privilege.CreateCollection, user) &&
					!Orciid.Core.User.HasPrivilege(Privilege.ManageCollectionGroups, user) &&
					!Orciid.Core.User.HasPrivilegeOnAny('C', user,
						Privilege.DeleteCollection, Privilege.ManageCollection, 
// FogBugz case 1892: Personal collection should not count at this point
//						Privilege.AddImages, Privilege.RemoveImages, Privilege.ModifyImages, 
						Privilege.ModifyACL))
				{
					HideMenuItem("Management_Collections");
				}

				if (!Orciid.Core.User.HasPrivilege(Privilege.ManageUsers, user) &&
					!Orciid.Core.User.HasPrivilege(Privilege.ResetPassword, user))
				{
					HideMenuItem("Management_Users");
				}
/*
				if (!Orciid.Core.User.HasPrivilege(Privilege.ViewStatistics, user) &&
					!Orciid.Core.User.HasPrivilege(Privilege.ClearStatistics, user))
				{
					HideMenuItem("Management_Statistics");
				}
*/				
				if (!user.Administrator && 
					!Orciid.Core.User.HasPrivilege(Privilege.ModifyACL, user))
				{
					HideMenuItem("Management_Settings");
				}

				if (!user.Administrator)
				{
					HideMenuItem("Management_TransactionLog");
					HideMenuItem("Management_BackgroundTasks");
				}

				HideEmptyMenuGroups();
			}
		}

		private void HideMenuItem(string item)
		{
			if (item.IndexOf("_") > 0)
			{
				HtmlTableRow row = LeftMenu.FindControl(item) as HtmlTableRow;
				if (row != null)
					row.Visible = false;
			}
			else
			{
				foreach (System.Web.UI.Control c in LeftMenu.Controls)
					if (c is HtmlTableRow && c.ID != null && (c.ID == item || c.ID.StartsWith(item + "_")))
						c.Visible = false;
			}
		}

		private void HideEmptyMenuGroups()
		{
			System.Web.UI.Control currentgroup = null;
			bool visiblesubitems = false;
			foreach (System.Web.UI.Control group in LeftMenu.Controls)
				if (group is HtmlTableRow && group.ID != null)
				{
					if (group.ID.IndexOf("_") > 0)
					{
						if (!group.ID.EndsWith("_Footer"))
							visiblesubitems = visiblesubitems || group.Visible;
					}
					else
					{
						if (currentgroup != null && !visiblesubitems)
							HideMenuItem(currentgroup.ID);
						currentgroup = group;
						visiblesubitems = false;
					}
				}
			if (currentgroup != null && !visiblesubitems)
				HideMenuItem(currentgroup.ID);
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		

		private void InitializeComponent()
		{
			this.MyMDID_Slideshows_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.MyMDID_Favorites_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.MyMDID_PersonalCollection_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.MyMDID_Options_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Resources_Slideshows_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Resources_Browse_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Resources_Search_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Resources_CollectionOverview_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Resources_Downloads_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Management_Collections_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Management_Users_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Management_TransactionLog_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Management_Settings_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Management_BackgroundTasks_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Information_Announcements_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Information_About_Button.Command += new System.Web.UI.WebControls.CommandEventHandler(this.MyMDID_LinkButton_Command);
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.PageMenu_PreRender);

		}
		#endregion

		private void MyMDID_LinkButton_Command(object sender, System.Web.UI.WebControls.CommandEventArgs e)
		{
			if (e.CommandName == "link")
			{
				Response.Redirect((string)e.CommandArgument); 
			}
		}

		private void PageMenu_PreRender(object sender, System.EventArgs e)
		{
			AddMouseOverCode(this.MyMDID_Slideshows_Button);
			AddMouseOverCode(this.MyMDID_Favorites_Button);
			AddMouseOverCode(this.MyMDID_PersonalCollection_Button);
			AddMouseOverCode(this.MyMDID_Options_Button);		
			AddMouseOverCode(this.Resources_Slideshows_Button);
			AddMouseOverCode(this.Resources_Browse_Button);
			AddMouseOverCode(this.Resources_Search_Button);
			AddMouseOverCode(this.Resources_CollectionOverview_Button);
			AddMouseOverCode(this.Resources_Downloads_Button);
			AddMouseOverCode(this.Management_Collections_Button);
			AddMouseOverCode(this.Management_Users_Button);
//			AddMouseOverCode(this.Management_Statistics_Button);
			AddMouseOverCode(this.Management_Settings_Button);
			AddMouseOverCode(this.Management_TransactionLog_Button);
			AddMouseOverCode(this.Management_BackgroundTasks_Button);
			AddMouseOverCode(this.Information_Announcements_Button);
			AddMouseOverCode(this.Information_About_Button);

			HideInaccessibleMenuItems();

			string highlightedscript = @"
<script language='JavaScript'>
var __highlighted = '';
</script>";
			System.Web.UI.Control page = Parent;
			while (page != null && !(page is OrciidPage))
				page = page.Parent;
			if (page != null)
			{
				string item = ((OrciidPage)page).GetHighlightedMenuItem();
				if (item != null)
				{
					HtmlTableRow row = LeftMenu.FindControl(item) as HtmlTableRow;
					if (row != null && row.Visible)
						 highlightedscript = String.Format(@"
<script language='JavaScript'>
var __highlighted = '{0}_Arrow';
</script>", item);
				}
			}		
			HighlightedMenuItem.Text = highlightedscript;
		}

	}
}
