<%@ Control Language="c#" AutoEventWireup="false" Codebehind="AttributeUserGroupProperties.ascx.cs" Inherits="Orciid.UserControls.AttributeUserGroupProperties" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<asp:DataGrid id="AttributeGrid" runat="server" showfooter="True" bordercolor="#DCE4EC" gridlines="Vertical"
	borderwidth="1px" cellpadding="4" AutoGenerateColumns="False">
	<AlternatingItemStyle CssClass="DataGridItemAlt" VerticalAlign="Top"></AlternatingItemStyle>
	<ItemStyle CssClass="DataGridItem" VerticalAlign="Top"></ItemStyle>
	<HeaderStyle Wrap="False" HorizontalAlign="Left" CssClass="DataGridHeader"></HeaderStyle>
	<FooterStyle Wrap="False" HorizontalAlign="Left" CssClass="DataGridFooter"></FooterStyle>
	<Columns>
		<asp:TemplateColumn>
			<HeaderTemplate><span id="AttributeHeadingSpan" runat="server">Attribute</span></HeaderTemplate>
			<ItemTemplate>
				<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Attribute") %>'>
				</asp:Label>
			</ItemTemplate>
			<EditItemTemplate>
				<asp:TextBox ID="attribute" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Attribute") %>'>
				</asp:TextBox>
			</EditItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn>
			<HeaderTemplate><span id="RequiredValueHeadingSpan" runat="server">Required Value</span></HeaderTemplate>
			<ItemTemplate>
				<asp:Label runat="server" Text='<%# String.Join("<br />", (string[])DataBinder.Eval(Container, "DataItem.Values")) %>'>
				</asp:Label>
			</ItemTemplate>
			<EditItemTemplate>
				<asp:TextBox TextMode="MultiLine" Columns="40" Rows="3" ID="values" runat="server" Text='<%# String.Join("\n", (string[])DataBinder.Eval(Container, "DataItem.Values")) %>'>
				</asp:TextBox>
			</EditItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn>
			<ItemTemplate>
				<asp:LinkButton id="DeleteButton" runat="server" Text="Delete" CommandName="Delete" CausesValidation="false"></asp:LinkButton>
			</ItemTemplate>
			<EditItemTemplate>
				<asp:LinkButton id="AddButton" runat="server" Text="Add" CommandName="Update" CausesValidation="false"></asp:LinkButton>
			</EditItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</asp:DataGrid>
