function CollectionSelection_ToggleGroup(group)
{
	for (var i = 0; i < group.form.elements.length; i++)
	{
		var e = group.form.elements[i];
		if (e.name && e.name != group.name && e.name.substring(0, group.name.length) == group.name)
			e.checked = group.checked;
	}
}

function CollectionSelection_ToggleCollection(collection)
{
	var groupname = collection.name.substring(0, collection.name.lastIndexOf('C'));
	var allselected = true;
	for (var i = 0; i < collection.form.elements.length; i++)
	{
		var e = collection.form.elements[i];
		if (e.name && e.name != groupname && e.name.substring(0, groupname.length) == groupname)
			allselected = allselected && e.checked;
	}
	collection.form.elements[groupname].checked = allselected;
	var keepopen = groupname.substring(0, groupname.lastIndexOf('G')) + 'keepopen';
	var groupnumber = groupname.substring(groupname.lastIndexOf('G') + 1, groupname.length);
	collection.form.elements[keepopen].value = groupnumber;
}

function CollectionSelection_ToggleTree(image)
{
	var imgpath = image.src.substring(0, image.src.lastIndexOf('/') + 1);
	var p = image.id.lastIndexOf('I');
	var span = document.getElementById(image.id.substring(0, p) + 'G' + image.id.substring(p + 1) + '__cs_span');
	if (span.style.display == 'none')
	{
		span.style.display = 'inline';
		image.src = imgpath + 'treenodeminus.gif';
	}
	else
	{
		span.style.display = 'none';
		image.src = imgpath + 'treenodeplus.gif';
	}	
}

function CollectionSelection_Initialize()
{
	var s = document.getElementsByTagName('span');
	var c = document.getElementsByTagName('input');
	var keepopen = 0;
	for (var i = 0; i < s.length; i++)
	{
		var sid = s[i].id;
		if (sid && sid.length > 9 && sid.substring(sid.length - 9) == '__cs_span')
		{
			var group = sid.substring(0, sid.length - 9);
			if (keepopen == 0)
			{
				var k =	document.getElementById(group.substring(0, group.lastIndexOf('G')) + 'keepopen');
				if (k && k.value != "")
				{
					keepopen = parseInt(k.value);
					k.value = "";
				}
			}
			var allchecked = true;
			var nonechecked = true;
			for (var j = 0; j < c.length; j++)
			{
				var box = c[j];
				if (box.id && box.id.length > group.length && box.id.substring(0, group.length) == group)
				{
					if (box.checked)
						nonechecked = false;
					else
						allchecked = false;
				}
			}
			document.getElementById(group).checked = allchecked;
			if (allchecked || nonechecked)
			{
				var p = group.lastIndexOf('G');
				var groupnumber = group.substring(p + 1);
				if (parseInt(groupnumber) != keepopen)
					CollectionSelection_ToggleTree(document.getElementById(group.substring(0, p) + 'I' + groupnumber));
			}
		}
	}
}
