namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;
	using Orciid.PageTemplate;

	public class PrivilegeDisplay : OrciidUserControl
	{
		protected System.Web.UI.WebControls.DataGrid AccessControlGrid;
		private IAccessControl acl;
		private int[] usergroupids;
		private int[] userids;

		public IAccessControl DataSource
		{
			set
			{
				acl = value;
			}
		}

		public override void DataBind()
		{
			if (acl != null)
			{
				userids = acl.GetPrivilegedUsers();
				Orciid.Core.User[] users = User.GetByID(userids);
				if (users != null)
				{
					Array.Sort(users);
					userids = new int[users.Length];
					for (int i = 0; i < userids.Length; i++)
						userids[i] = users[i].ID;
				}
				else
					userids = new int[0];

				usergroupids = acl.GetPrivilegedGroups();
				UserGroup[] groups = UserGroup.GetByID(usergroupids);
				if (groups != null)
				{
					Array.Sort(groups);
					usergroupids = new int[groups.Length];
					for (int i = 0; i < usergroupids.Length; i++)
						usergroupids[i] = groups[i].ID;
				}
				else
					usergroupids = new int[0];

				ArrayList data = new ArrayList(users.Length + groups.Length);
				data.AddRange(groups);
				data.AddRange(users);
				AccessControlGrid.DataSource = data;
				AccessControlGrid.DataBind();
			}
			else
				this.Visible = false;
		}


		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				userids = (int[])ViewState["userids"];
				usergroupids = (int[])ViewState["usergroupids"];
			}
		}

		protected override object SaveViewState()
		{
			ViewState["userids"] = userids;
			ViewState["usergroupids"] = usergroupids;
			return base.SaveViewState();
		}

		public int[] GetSelectedUsers()
		{
			ArrayList selected = new ArrayList();
			for (int i = 0; i < userids.Length; i++)
			{
				CheckBox checkbox = AccessControlGrid.Items[i + usergroupids.Length].FindControl("SelectCheckBox") as CheckBox;
				if (checkbox.Checked)
					selected.Add(userids[i]);
			}
			return (int[])selected.ToArray(typeof(int));
		}

		public int[] GetSelectedUserGroups()
		{
			ArrayList selected = new ArrayList();
			for (int i = 0; i < usergroupids.Length; i++)
			{
				CheckBox checkbox = AccessControlGrid.Items[i].FindControl("SelectCheckBox") as CheckBox;
				if (checkbox.Checked)
					selected.Add(usergroupids[i]);
			}
			return (int[])selected.ToArray(typeof(int));
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private DataGridItem GetDataGridItem(Control control)
		{
			while (!(control is DataGridItem) && control.Parent != null)
				control = control.Parent;
			return control as DataGridItem;
		}

		protected void DataBindUserImage(object sender, System.EventArgs e)
		{
			System.Web.UI.WebControls.Image image = sender as System.Web.UI.WebControls.Image;
			DataGridItem item = GetDataGridItem(image);
			Control current = this.Parent;
			while (current != null && !(current is Page))
				current = current.Parent;
			if (current != null)
			{
				if (item.DataItem is Orciid.Core.User)
					image.ImageUrl = current.ResolveUrl("images/usericon.gif");
				else if (item.DataItem is UserGroup)
					image.ImageUrl = current.ResolveUrl("images/groupicon.gif");
				else
					image.Visible = false;
			}
			else
				image.Visible = false;
		}

		protected void DataBindUserLabel(object sender, System.EventArgs e)
		{
			Label control = sender as Label;
			DataGridItem item = GetDataGridItem(control);
			control.Text = ((IPrivilegeAssignee)item.DataItem).GetName();
		}

		protected void DataBindAllowLabel(object sender, System.EventArgs e)
		{
			Label control = sender as Label;
			DataGridItem item = GetDataGridItem(control);
			Privilege priv = acl.GetGrantedPrivileges((IPrivilegeAssignee)item.DataItem);
			for (int i = 0; i < 32; i++)
			{
				Privilege p = (Privilege)(1 << i);
				if ((priv & p) == p)
					control.Text += GetPrivilegeLabel(p) + "<br />";
			}	
			if (control.Text == "")
				control.Text = "<center>-</center>";
		}

		protected void DataBindDenyLabel(object sender, System.EventArgs e)
		{
			Label control = sender as Label;
			DataGridItem item = GetDataGridItem(control);
			Privilege priv = acl.GetDeniedPrivileges((IPrivilegeAssignee)item.DataItem);
			for (int i = 0; i < 32; i++)
			{
				Privilege p = (Privilege)(1 << i);
				if ((priv & p) == p)
					control.Text += GetPrivilegeLabel(p) + "<br />";
			}				
			if (control.Text == "")
				control.Text = "<center>-</center>";
		}
	}
}
