using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class addimages : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Panel SearchPanel;
		protected System.Web.UI.WebControls.Panel BrowsePanel;
		protected System.Web.UI.WebControls.Panel PersonalCollectionPanel;
		protected System.Web.UI.WebControls.Panel FavoritesPanel;
		protected System.Web.UI.WebControls.LinkButton BrowseLinkButton;
		protected System.Web.UI.WebControls.LinkButton PersonalCollectionLinkButton;
		protected System.Web.UI.WebControls.LinkButton FavoritesLinkButton;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DescriptionParagraph;
		protected System.Web.UI.HtmlControls.HtmlGenericControl SearchLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl BrowseLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl PersonalCollectionLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl FavoritesLabelSpan;
		protected System.Web.UI.WebControls.LinkButton SearchLinkButton;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			SearchPanel.Visible = Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.ReadCollection);
			BrowsePanel.Visible = SearchPanel.Visible;
			PersonalCollectionPanel.Visible = Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.PersonalImages);
			FavoritesCollection favcoll = FavoritesCollection.GetFavoritesCollection();
			FavoritesPanel.Visible = (favcoll != null && 
				Orciid.Core.User.HasPrivilege(Privilege.ReadCollection, favcoll, user));
		}

		public override string GetHighlightedMenuItem()
		{
			return null;
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilege(Privilege.CreateSlideshow, user) ||
				Orciid.Core.User.HasPrivilegeOnAny('S', user, Privilege.ModifySlideshow, 
				Privilege.DeleteSlideshow, Privilege.ViewSlideshow, 
				Privilege.ModifyACL);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.SearchLinkButton.Click += new System.EventHandler(this.SearchLinkButton_Click);
			this.BrowseLinkButton.Click += new System.EventHandler(this.BrowseLinkButton_Click);
			this.PersonalCollectionLinkButton.Click += new System.EventHandler(this.PersonalCollectionLinkButton_Click);
			this.FavoritesLinkButton.Click += new System.EventHandler(this.FavoritesLinkButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SearchLinkButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("search.aspx"); 
		}

		private void BrowseLinkButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("browse.aspx"); 
		}

		private void PersonalCollectionLinkButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("personalcollection.aspx?list=yes");
		}

		private void FavoritesLinkButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("favorites.aspx?list=yes");
		}
	}
}
