using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class collectioninfo : PageTemplate.OrciidPage
	{
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.WebControls.Repeater CollectionRepeater;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		public override string GetHighlightedMenuItem()
		{
			return "Resources_CollectionOverview";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.ReadCollection);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.collectioninfo_PreRender);

		}
		#endregion

		protected void DataBindCollectionImage(object sender, System.EventArgs e)
		{
			PlaceHolder placeholder = sender as PlaceHolder;
			RepeaterItem item = placeholder.Parent as RepeaterItem;
			Collection coll = item.DataItem as Collection;

			System.Web.UI.WebControls.Image image = new System.Web.UI.WebControls.Image();
            image.ImageUrl = "images/spacer.gif";
			image.Width = 96;
			image.Height = 72;
			image.BorderStyle = BorderStyle.None;

			placeholder.Controls.Add(image);
			placeholder.Controls.Add(new LiteralControl("<br />"));

			if (coll != null)
			{
				if (coll.IsBrowsable)
				{
					HyperLink link = new HyperLink();
					link.Text = GetLocalString(this, "Browse", "Browse");
					link.NavigateUrl = String.Format("browse.aspx?cid={0}", coll.ID);
					placeholder.Controls.Add(link);
					placeholder.Controls.Add(new LiteralControl(" "));
				}

				if (coll.Type == CollectionType.Internal)
				{
					HyperLink tlink = new HyperLink();
					tlink.Text = GetLocalString(this, "Terms", "Terms");
					tlink.NavigateUrl = String.Format("terms.aspx?c={0}", coll.ID);
					placeholder.Controls.Add(tlink);
					placeholder.Controls.Add(new LiteralControl(" "));
				}
					
				if (coll.Type == CollectionType.Favorites)
				{
					Orciid.Core.User user = Orciid.Core.User.CurrentUser();
					if (user != null)
					{
						ImageIdentifier[] ids = user.GetFavoriteImages();
						if (ids != null && ids.Length > 0)
						{
							ImageIdentifier id = ids[new Random().Next(ids.Length - 1)];
							image.ImageUrl = String.Format("getimage.aspx?id={0}&cid={1}&format=T",
								id.ID, id.CollectionID);
						}
					}
				}
				else
				{
					Properties props = Properties.GetProperties(coll);
					string thumbnail = props.Get("repimage", null);
					if (thumbnail != null)
					{
						if (thumbnail.StartsWith("http://"))
							image.ImageUrl = thumbnail;
						else
							image.ImageUrl = String.Format("getimage.aspx?res={0}&cid={1}&format=T",
								Server.UrlEncode(thumbnail), coll.ID);
					}
				}				
			}
		}

		protected void DataBindUsageAgreementPanel(object sender, System.EventArgs e)
		{
			Panel panel = sender as Panel;
			RepeaterItem item = panel.Parent as RepeaterItem;
			Collection coll = item.DataItem as Collection;
			panel.Visible = 
				(coll != null && coll.UsageAgreement != null && coll.UsageAgreement.Length > 0);
		}

		protected void DataBindImageCountDisplay(object sender, System.EventArgs e)
		{
			PlaceHolder span = sender as PlaceHolder;
			RepeaterItem item = span.Parent as RepeaterItem;
			Collection coll = item.DataItem as Collection;
			int count = (coll != null ? coll.ImageCount : -1);
			span.Visible = count >= 0;
			if (span.Visible)
			{
				Label l = new Label();
				string pattern;
				if (count == 1)
					pattern = GetLocalString(this, "RecordLabel", "(1 record)");
				else
					pattern = GetLocalString(this, "RecordsLabel", "({0} records)");
				l.Text = String.Format(pattern, count);
				span.Controls.Add(l);
			}
		}
		
		private void collectioninfo_PreRender(object sender, System.EventArgs e)
		{
			Collection coll = null;
			try
			{
				coll = Collection.GetByID(Int32.Parse(Request.QueryString["cid"]));
			}
			catch
			{
			}
			Collection[] colls;
			if (coll == null)
				colls = Collection.GetCollections();
			else
				colls = new Collection[] { coll };
			CollectionRepeater.DataSource = colls;
			CollectionRepeater.DataBind();
		}
	}
}
