using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using System.IO;
using Orciid.Core;

namespace Orciid
{
	public class EmailImportPage : PageTemplate.OrciidPage
	{
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.WebControls.CheckBox EnableCamioEmailRetrievalCheckBox;
		protected System.Web.UI.WebControls.DropDownList TargetCollectionDropDownList;
		protected System.Web.UI.WebControls.TextBox ImageOwnerTextBox;
		protected System.Web.UI.WebControls.TextBox Pop3ServerTextBox;
		protected System.Web.UI.WebControls.CheckBox Pop3SSLCheckBox;
		protected System.Web.UI.WebControls.TextBox EmailAccountTextBox;
		protected System.Web.UI.WebControls.TextBox EmailPasswordTextBox;
		protected System.Web.UI.WebControls.DropDownList UpdateFrequencyDropDownList;
		protected System.Web.UI.WebControls.Button SaveSettingsButton;
		protected System.Web.UI.WebControls.Button RetrieveImagesNowButton;
		protected System.Web.UI.WebControls.TextBox Pop3ServerPortTextBox;
		protected System.Web.UI.WebControls.TextBox PrefixTextBox;
		protected System.Web.UI.HtmlControls.HtmlGenericControl TargetCollectionLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl ImageOwnerLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl UnlessOwnerSpecifiedLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl ImageIdentifierPrefixLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Pop3ServerLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Pop3ServerPortLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Pop3OptionsLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl EmailAccountLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl EmailPasswordLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl UpdateFrequencyLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl UpdateEveryLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl UpdateHoursLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl SettingsSubheading;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				Properties props = Properties.GetSystemProperties();
				EnableCamioEmailRetrievalCheckBox.Checked = (props.GetAsInt("camioenabled", 0) != 0);
				TargetCollectionDropDownList.Items.Clear();
				TargetCollectionDropDownList.Items.Add(new ListItem("", "0"));
				foreach (Collection coll in Collection.GetCollections(CollectionType.Internal))
					TargetCollectionDropDownList.Items.Add(new ListItem(coll.Title, coll.ID.ToString()));
				try
				{
					TargetCollectionDropDownList.SelectedValue = props.Get("camiocollid", "0");
				}
				catch (ArgumentOutOfRangeException)
				{
					TargetCollectionDropDownList.SelectedValue = "0";
				}
				ImageOwnerTextBox.Text = props.Get("camioimgowner", "");
				PrefixTextBox.Text = props.Get("camioprefix", "");
				Pop3ServerTextBox.Text = props.Get("camiopop3server", "");
				Pop3ServerPortTextBox.Text = props.Get("camiopop3port", "110");
				Pop3SSLCheckBox.Checked = (props.GetAsInt("camiopop3ssl", 0) != 0);
				EmailAccountTextBox.Text = props.Get("camioaccount", "");
				EmailPasswordTextBox.Text = "";
				UpdateFrequencyDropDownList.Items.Clear();
				UpdateFrequencyDropDownList.Items.Add(new ListItem("1", "1"));
				UpdateFrequencyDropDownList.Items.Add(new ListItem("2", "2"));
				UpdateFrequencyDropDownList.Items.Add(new ListItem("4", "4"));
				UpdateFrequencyDropDownList.Items.Add(new ListItem("12", "12"));
				UpdateFrequencyDropDownList.Items.Add(new ListItem("24", "24"));
				UpdateFrequencyDropDownList.SelectedValue = props.Get("camiofrequency", "2");
			}
		}

		public override string GetHighlightedMenuItem()
		{
			return "Management_Settings";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return (user != null && user.Administrator);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.SaveSettingsButton.Click += new System.EventHandler(this.SaveSettingsButton_Click);
			this.RetrieveImagesNowButton.Click += new System.EventHandler(this.RetrieveImagesNowButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SaveSettingsButton_Click(object sender, System.EventArgs e)
		{
			Properties props = Properties.GetSystemProperties();
			props.SetAsInt("camioenabled", EnableCamioEmailRetrievalCheckBox.Checked ? 1 : 0);
			props.Set("camiocollid", TargetCollectionDropDownList.SelectedValue);
			props.Set("camioimgowner", ImageOwnerTextBox.Text);
			props.Set("camioprefix", PrefixTextBox.Text);
			props.Set("camiopop3server", Pop3ServerTextBox.Text);
			props.Set("camiopop3port", Pop3ServerPortTextBox.Text);
			props.SetAsInt("camiopop3ssl", Pop3SSLCheckBox.Checked ? 1 : 0);
			props.Set("camioaccount", EmailAccountTextBox.Text);
			if (EmailPasswordTextBox.Text.Length > 0)
				props.Set("camiopassword", EmailPasswordTextBox.Text);
			props.Set("camiofrequency", UpdateFrequencyDropDownList.SelectedValue);
			Orciid.Core.Camio.CamioEmailImport.Initialize();
			ShowInformation(GetLocalString(this, "SettingsSaved", "Settings have been saved."));
		}

		private void RetrieveImagesNowButton_Click(object sender, System.EventArgs e)
		{
			if (Orciid.Core.Camio.CamioEmailImport.RunNow())
				ShowInformation(GetLocalString(this, "RunNow", "Task has been scheduled to run immediately"));
			else
				ShowWarning(GetLocalString(this, "RunNowFailed", "Task could not be scheduled to run immediately - it may be running already"));
		}
	}
}
