using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class permissions : PageTemplate.OrciidPage
	{
		protected System.Web.UI.HtmlControls.HtmlGenericControl Title;
		protected System.Web.UI.WebControls.Label TitleLabel;
		protected System.Web.UI.WebControls.HyperLink BackHyperLink;
		protected Orciid.UserControls.ACLControl ItemAccessControl;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
			
		private IAccessControlled item;

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				try
				{
					item = AccessControl.GetAccessControlledObject(
						(Request.QueryString["type"].ToCharArray(0, 1))[0],
						Int32.Parse(Request.QueryString["id"]));
					TitleLabel.Text = item.GetTitle();
					ItemAccessControl.DataSource = item;					
				}
				catch
				{
					string error = GetLocalString(this, "ItemNotFound", "Could not retrieve requested item.");
					ShowError(error);
					TitleLabel.Text = error;
					ItemAccessControl.Visible = false;
				}	
				DataBind();
			}
			if (!Orciid.Core.User.HasPrivilege(Privilege.ModifyACL, item))
				Response.Redirect("insufficientprivileges.aspx"); 
		}

		protected override void LoadViewState(object savedState)
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				try
				{
					item = AccessControl.GetAccessControlledObject(
						(char)ViewState["type"], (int)ViewState["id"]);
				}
				catch
				{
					item = null;
				}
				if (item == null)
				{
					string error = GetLocalString(this, "ItemNotFound", "Could not retrieve requested item.");
					ShowError(error);
					TitleLabel.Text = error;
					ItemAccessControl.Visible = false;
				}
			}
		}

		protected override object SaveViewState()
		{
			if (item != null)
			{
				ViewState["type"] = item.GetObjectTypeIdentifier();
				ViewState["id"] = item.GetID();
			}
			return base.SaveViewState();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.BackHyperLink.DataBinding += new System.EventHandler(this.BackHyperLink_DataBinding);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return true;
		}

		public override string GetHighlightedMenuItem()
		{
			return null;
		}

		private void BackHyperLink_DataBinding(object sender, System.EventArgs e)
		{
			HyperLink link = sender as HyperLink;
			string url = Request.QueryString["url"];
			if (url != null && url.Length > 0)
				link.NavigateUrl = url;
			else
				link.Visible = false;
		}
	}
}
