using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class personalcollection : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Button CreateButton;
		protected System.Web.UI.WebControls.LinkButton ViewImagesButton;
		protected System.Web.UI.WebControls.Panel NewImagePanel;
		protected System.Web.UI.WebControls.Image NewImage;
		protected Orciid.UserControls.ImageRecordDisplay NewImageRecordDisplay;
		protected System.Web.UI.WebControls.DropDownList CollectionDropDownList;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NewlyCreatedImageHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CreateNewImage;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CollectionLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CreateNewImageDiv;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				if (Request.QueryString["list"] != null)
					ListImages();
				CollectionDropDownList.Items.Clear();
				foreach (Collection coll in Collection.GetCollections(CollectionType.Internal))
					if (Orciid.Core.User.HasPrivilege(Privilege.PersonalImages, coll))
						CollectionDropDownList.Items.Add(new ListItem(coll.Title, coll.ID.ToString()));
				CreateNewImageDiv.Visible = (CollectionDropDownList.Items.Count > 0);
			}
		}

		public override string GetHighlightedMenuItem()
		{
			return "MyMDID_PersonalCollection";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.PersonalImages);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ViewImagesButton.Click += new System.EventHandler(this.ViewImagesButton_Click);
			this.CreateButton.Click += new System.EventHandler(this.CreateButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void CreateButton_Click(object sender, System.EventArgs e)
		{
			Collection coll = null;
			try
			{
				coll = Collection.GetByID(Int32.Parse(CollectionDropDownList.SelectedValue));
			}
			catch
			{
			}
			if (coll != null)
			{
				ImageIdentifier id = new ImageIdentifier(0, coll.ID);
				Response.Redirect(String.Format("editor.aspx?id={0}&return={1}&personal=true", 
					id, "personalcollection.aspx"));
			}
		}

		private void ListImages()
		{
			ArrayList result = new ArrayList();
			foreach (Collection coll in Collection.GetCollections())
				if (Orciid.Core.User.HasPrivilege(Privilege.PersonalImages, coll))
				{
					ImageIdentifier[] r = coll.GetPersonalImages();
					if (r != null)
						result.AddRange(r);
				}
			if (result.Count > 0)
			{
				Session["LastSearchResult"] = new ResultPageOptions(
					GetLocalString(this, "MyImages", "My Images"), 
					"personalcollection.aspx", 
					GetLocalString(this, "BackToMyImages", "Back to My Images"), 
					(ImageIdentifier[])result.ToArray(typeof(ImageIdentifier)));
				Response.Redirect("result.aspx"); 
			}
			else
			{
				ShowWarning(GetLocalString(this, "NoImages", "There are no images in your personal collection."));
			}		
		}

		private void ViewImagesButton_Click(object sender, System.EventArgs e)
		{
			ListImages();
		}
	}
}
