using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class users : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Panel SubMenuPanel;
		protected System.Web.UI.HtmlControls.HtmlImage UserAccountsMarkLeftL;
		protected System.Web.UI.HtmlControls.HtmlImage UserAccountsMarkRightL;
		protected System.Web.UI.HtmlControls.HtmlImage UserAccountsMarkLeftS;
		protected System.Web.UI.HtmlControls.HtmlImage UserAccountsMarkRightS;
		protected System.Web.UI.HtmlControls.HtmlImage UserGroupsMarkLeft;
		protected System.Web.UI.HtmlControls.HtmlImage UserGroupsMarkRight;
		protected System.Web.UI.WebControls.LinkButton UserGroupsButton;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.WebControls.LinkButton UserAccountsButtonS;
		protected System.Web.UI.WebControls.LinkButton UserAccountsButtonL;
		
		private void Page_Load(object sender, System.EventArgs e)
		{

// add LinkButton on demo site installations that removes old user accounts	
#if DEMO
#warning Compiling for Demo site
			LinkButton b = new LinkButton();
			b.Text = "Remove old users";
			b.Click += new EventHandler(RemoveOldUsers_Click);
			SubMenuPanel.Controls.Add(new LiteralControl(" - "));
			SubMenuPanel.Controls.Add(b);
#endif
		}

		private void RemoveOldUsers_Click(object sender, EventArgs e)
		{
#if DEMO
#warning Compiling for Demo site
			DemoUserCleanup.Run();
#endif
			this.ShowInformation("Old demo user accounts have been removed");
		}

		public override string GetHighlightedMenuItem()
		{
			return "SystemTools_ManageUsers";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilege(Privilege.ManageUsers, user) ||
				Orciid.Core.User.HasPrivilege(Privilege.ResetPassword, user);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.UserAccountsButtonS.Click += new System.EventHandler(this.UserAccountsButtonS_Click);
			this.UserAccountsButtonL.Click += new System.EventHandler(this.UserAccountsButtonL_Click);
			this.UserGroupsButton.Click += new System.EventHandler(this.UserGroupsButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SwitchControls(bool aS, bool aL, bool g)
		{
			UserAccountsControl accounts = FindControl("UserAccounts") as UserAccountsControl; // Default
			UserAccountsControlName accounts2 = FindControl("UserAccountsByName") as UserAccountsControlName;
			UserGroupsControl groups = FindControl("UserGroups") as UserGroupsControl;
			accounts.Visible = aL;
			accounts2.Visible = aS;
			if (aL)
				accounts.Reset();
			if (aS)
				accounts2.Reset();
			UserAccountsMarkLeftS.Visible = aS;
			UserAccountsMarkRightS.Visible = aS;
			UserAccountsMarkLeftL.Visible = aL;
			UserAccountsMarkRightL.Visible = aL;

			groups.Visible = g;
			if (g)
				groups.Reset();
			UserGroupsMarkLeft.Visible = g;
			UserGroupsMarkRight.Visible = g;
		}

		private void UserAccountsButtonS_Click(object sender, System.EventArgs e)
		{
			//Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			SwitchControls(true, false, false);
		}

		private void UserAccountsButtonL_Click(object sender, System.EventArgs e)
		{
			//Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			SwitchControls(false, true, false);
		}

		private void UserGroupsButton_Click(object sender, System.EventArgs e)
		{
			//Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			SwitchControls(false, false, true);
		}
	}
}
