using System;
using System.Collections;
using System.IO;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for full-text index directory methods
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestFullTextIndexDirectories
	{
		private string tempdirectory = null;

		/// <summary>
		/// Test setup
		/// </summary>
		/// <remarks>
		/// Test setup
		/// </remarks>
		[SetUp]
		public void Setup()
		{
			string temp = Path.GetTempPath();
			int i = 0;
			do
			{
				tempdirectory = Path.Combine(temp, "fulltextindex" + i.ToString());
				i++;
			} while (Directory.Exists(tempdirectory));
			Directory.CreateDirectory(tempdirectory);
			Console.WriteLine("Using {0} as temporary directory", tempdirectory);
		}

		/// <summary>
		/// Test cleanup
		/// </summary>
		/// <remarks>
		/// Test cleanup
		/// </remarks>
		[TearDown] 
		public void Cleanup()
		{
			if (tempdirectory != null)
				Directory.Delete(tempdirectory, true);
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests full-text index directory methods
		/// </remarks>
		[Test]
		public void GetNonExistent()
		{
			FullTextIndex index = new FullTextIndex(null);
			string path = index.GetCurrentIndexPath(tempdirectory);
			Assert.IsNull(path);
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests full-text index directory methods
		/// </remarks>
		[Test]
		public void CreateAndRemove()
		{
			FullTextIndex index = new FullTextIndex(null);

			string newpath1 = index.GetNewIndexPath(tempdirectory);
			Assert.IsFalse(Directory.Exists(newpath1));
			Directory.CreateDirectory(newpath1);
			Assert.IsTrue(Directory.Exists(newpath1));
			Console.WriteLine(newpath1);

			string newpath2 = index.GetNewIndexPath(tempdirectory);
			Assert.IsFalse(Directory.Exists(newpath2));
			Directory.CreateDirectory(newpath2);
			Assert.IsTrue(Directory.Exists(newpath2));
			Console.WriteLine(newpath2);

			string current = index.GetCurrentIndexPath(tempdirectory);
			Assert.AreEqual(newpath2, current);

			index.RemoveOldIndexDirectories(tempdirectory);
			Assert.IsFalse(Directory.Exists(newpath1));
			Assert.IsTrue(Directory.Exists(newpath2));
		}
	}
}
