using System;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for <see cref="SoundEx"/> class.
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestSoundEx
	{
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestCalculate()
		{
			Assert.AreEqual("", SoundEx.Calculate("X"));
			Assert.AreEqual("S000", SoundEx.Calculate("Shoe"));
			Assert.AreEqual("S0", SoundEx.Calculate("Shoe", 2));
			Assert.AreEqual("E460", SoundEx.Calculate("Euler"));
			Assert.AreEqual("E460", SoundEx.Calculate("Ellery"));
			Assert.AreEqual("G200", SoundEx.Calculate("Gauss"));
			Assert.AreEqual("G200", SoundEx.Calculate("Ghosh"));
			Assert.AreEqual("H416", SoundEx.Calculate("Hilbert"));
			Assert.AreEqual("H416", SoundEx.Calculate("Heilbronn"));
			Assert.AreEqual("K530", SoundEx.Calculate("Knuth"));
			Assert.AreEqual("K530", SoundEx.Calculate("Kant"));
			Assert.AreEqual("L300", SoundEx.Calculate("Lloyd"));
			Assert.AreEqual("L300", SoundEx.Calculate("Ladd"));
			Assert.AreEqual("L222", SoundEx.Calculate("Lukasiewicz"));
			Assert.AreEqual("L222", SoundEx.Calculate("Lissajous"));		
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestCompare()
		{
			Assert.AreEqual(0, SoundEx.Compare("Hammer", "Honor"));
			Assert.AreNotEqual(0, SoundEx.Compare("Shoe", "Hammer"));
		}
	}
}
