using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Threading;

namespace imagemanager
{
	/// <summary>
	/// Summary description for ProgressForm.
	/// </summary>
	public class ProgressForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label messageLabel;
		private System.Windows.Forms.Panel controlsPanel;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.ProgressBar progressBar;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private bool cancelpressed = false;
		private bool canclose = true;

		public bool CancelPressed
		{
			get
			{
				return cancelpressed;
			}
		}

		public bool ShowProgressBar
		{
			get
			{
				return progressBar.Visible;
			}
			set
			{
				progressBar.Visible = value;
			}
		}	

		public bool ShowCancelButton
		{
			get
			{
				return cancelButton.Visible;
			}
			set
			{
				cancelButton.Visible = value;
				ControlBox = value;
				canclose = value;
			}
		}
	
		public int Progress
		{
			get
			{
				return progressBar.Value;
			}
			set
			{
				progressBar.Value = value;
			}
		}

		public string Message
		{
			get
			{
				return messageLabel.Text;
			}
			set
			{
				messageLabel.Text = value;
			}
		}

		public ProgressForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// Add any constructor code after InitializeComponent call
			//
		}

		public ProgressForm(string title, string message, bool progressbar, bool cancelbutton):
			this()
		{
			Text = title;
			Message = message;
			ShowProgressBar = progressbar;
			ShowCancelButton = cancelbutton;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.messageLabel = new System.Windows.Forms.Label();
			this.controlsPanel = new System.Windows.Forms.Panel();
			this.cancelButton = new System.Windows.Forms.Button();
			this.progressBar = new System.Windows.Forms.ProgressBar();
			this.controlsPanel.SuspendLayout();
			this.SuspendLayout();
			// 
			// messageLabel
			// 
			this.messageLabel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.messageLabel.Location = new System.Drawing.Point(0, 0);
			this.messageLabel.Name = "messageLabel";
			this.messageLabel.Size = new System.Drawing.Size(290, 85);
			this.messageLabel.TabIndex = 0;
			this.messageLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// controlsPanel
			// 
			this.controlsPanel.Controls.Add(this.cancelButton);
			this.controlsPanel.Controls.Add(this.progressBar);
			this.controlsPanel.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.controlsPanel.Location = new System.Drawing.Point(0, 85);
			this.controlsPanel.Name = "controlsPanel";
			this.controlsPanel.Size = new System.Drawing.Size(290, 80);
			this.controlsPanel.TabIndex = 2;
			// 
			// cancelButton
			// 
			this.cancelButton.Location = new System.Drawing.Point(200, 40);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.Size = new System.Drawing.Size(80, 23);
			this.cancelButton.TabIndex = 3;
			this.cancelButton.Text = "Cancel";
			this.cancelButton.Click += new System.EventHandler(this.cancelButton_Click);
			// 
			// progressBar
			// 
			this.progressBar.Location = new System.Drawing.Point(8, 8);
			this.progressBar.Name = "progressBar";
			this.progressBar.Size = new System.Drawing.Size(272, 23);
			this.progressBar.TabIndex = 2;
			// 
			// ProgressForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(290, 165);
			this.Controls.Add(this.messageLabel);
			this.Controls.Add(this.controlsPanel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ProgressForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.ProgressForm_Closing);
			this.controlsPanel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void cancelButton_Click(object sender, System.EventArgs e)
		{
			cancelpressed = true;
			cancelButton.Enabled = false;
		}

		private void ProgressForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (!canclose)
				e.Cancel = true;
		}

		public void Finished()
		{
			canclose = true;
			Close();
		}
	}
}
