using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace imagemanager
{
	/// <summary>
	/// Summary description for PropertiesForm.
	/// </summary>
	public class PropertiesForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.Label RecordIdentifierLabel;
		private System.Windows.Forms.Label RecordIdentifierValueLabel;
		private System.Windows.Forms.Label ResourceLabel;
		private System.Windows.Forms.Label StatusLabel;
		private System.Windows.Forms.Label ActionLabel;
		private System.Windows.Forms.Label StatusValueLabel;
		private System.Windows.Forms.ComboBox ActionComboBox;
		private System.Windows.Forms.Button BrowseButton;
		private System.Windows.Forms.Button OKButton;
		private System.Windows.Forms.Button FormCancelButton;
		private System.Windows.Forms.Label LocalResourceLabel;
		private System.Windows.Forms.TextBox LocalResourceTextBox;
		private System.Windows.Forms.TextBox ResourceTextBox;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public string Action
		{
			get
			{
				return (string)ActionComboBox.SelectedItem;
			}
		}

		public string LocalResource
		{
			get
			{
				return LocalResourceTextBox.Text;
			}
		}

		public PropertiesForm(string record, string resource, string status, 
			string action, string localresource)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// Add any constructor code after InitializeComponent call
			//
			RecordIdentifierValueLabel.Text = record;
			ResourceTextBox.Text = resource;
			StatusValueLabel.Text = status;
			LocalResourceTextBox.Text = localresource;
			ActionComboBox.SelectedItem = action;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.RecordIdentifierLabel = new System.Windows.Forms.Label();
			this.RecordIdentifierValueLabel = new System.Windows.Forms.Label();
			this.ResourceLabel = new System.Windows.Forms.Label();
			this.StatusLabel = new System.Windows.Forms.Label();
			this.ActionLabel = new System.Windows.Forms.Label();
			this.LocalResourceLabel = new System.Windows.Forms.Label();
			this.StatusValueLabel = new System.Windows.Forms.Label();
			this.ActionComboBox = new System.Windows.Forms.ComboBox();
			this.LocalResourceTextBox = new System.Windows.Forms.TextBox();
			this.BrowseButton = new System.Windows.Forms.Button();
			this.OKButton = new System.Windows.Forms.Button();
			this.FormCancelButton = new System.Windows.Forms.Button();
			this.ResourceTextBox = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// openFileDialog
			// 
			this.openFileDialog.Filter = "JPEG files|*.jpg|Bitmap files|*.bmp|TIFF files|*.tif|All files|*.*";
			this.openFileDialog.Title = "Select Image File";
			// 
			// RecordIdentifierLabel
			// 
			this.RecordIdentifierLabel.Location = new System.Drawing.Point(8, 8);
			this.RecordIdentifierLabel.Name = "RecordIdentifierLabel";
			this.RecordIdentifierLabel.Size = new System.Drawing.Size(88, 16);
			this.RecordIdentifierLabel.TabIndex = 0;
			this.RecordIdentifierLabel.Text = "Record Identifier";
			// 
			// RecordIdentifierValueLabel
			// 
			this.RecordIdentifierValueLabel.Location = new System.Drawing.Point(96, 8);
			this.RecordIdentifierValueLabel.Name = "RecordIdentifierValueLabel";
			this.RecordIdentifierValueLabel.Size = new System.Drawing.Size(176, 16);
			this.RecordIdentifierValueLabel.TabIndex = 1;
			// 
			// ResourceLabel
			// 
			this.ResourceLabel.Location = new System.Drawing.Point(8, 32);
			this.ResourceLabel.Name = "ResourceLabel";
			this.ResourceLabel.Size = new System.Drawing.Size(88, 16);
			this.ResourceLabel.TabIndex = 2;
			this.ResourceLabel.Text = "Resource";
			// 
			// StatusLabel
			// 
			this.StatusLabel.Location = new System.Drawing.Point(8, 56);
			this.StatusLabel.Name = "StatusLabel";
			this.StatusLabel.Size = new System.Drawing.Size(88, 16);
			this.StatusLabel.TabIndex = 4;
			this.StatusLabel.Text = "Status";
			// 
			// ActionLabel
			// 
			this.ActionLabel.Location = new System.Drawing.Point(8, 80);
			this.ActionLabel.Name = "ActionLabel";
			this.ActionLabel.Size = new System.Drawing.Size(88, 16);
			this.ActionLabel.TabIndex = 5;
			this.ActionLabel.Text = "Action";
			// 
			// LocalResourceLabel
			// 
			this.LocalResourceLabel.Location = new System.Drawing.Point(8, 104);
			this.LocalResourceLabel.Name = "LocalResourceLabel";
			this.LocalResourceLabel.Size = new System.Drawing.Size(88, 16);
			this.LocalResourceLabel.TabIndex = 6;
			this.LocalResourceLabel.Text = "Local Resource";
			// 
			// StatusValueLabel
			// 
			this.StatusValueLabel.Location = new System.Drawing.Point(96, 56);
			this.StatusValueLabel.Name = "StatusValueLabel";
			this.StatusValueLabel.Size = new System.Drawing.Size(176, 16);
			this.StatusValueLabel.TabIndex = 7;
			// 
			// ActionComboBox
			// 
			this.ActionComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.ActionComboBox.Items.AddRange(new object[] {
																"None",
																"Upload"});
			this.ActionComboBox.Location = new System.Drawing.Point(96, 72);
			this.ActionComboBox.Name = "ActionComboBox";
			this.ActionComboBox.Size = new System.Drawing.Size(176, 21);
			this.ActionComboBox.TabIndex = 8;
			// 
			// LocalResourceTextBox
			// 
			this.LocalResourceTextBox.Location = new System.Drawing.Point(96, 96);
			this.LocalResourceTextBox.Name = "LocalResourceTextBox";
			this.LocalResourceTextBox.Size = new System.Drawing.Size(176, 20);
			this.LocalResourceTextBox.TabIndex = 9;
			this.LocalResourceTextBox.Text = "";
			this.LocalResourceTextBox.TextChanged += new System.EventHandler(this.LocalResourceTextBox_TextChanged);
			// 
			// BrowseButton
			// 
			this.BrowseButton.Location = new System.Drawing.Point(280, 96);
			this.BrowseButton.Name = "BrowseButton";
			this.BrowseButton.TabIndex = 10;
			this.BrowseButton.Text = "Browse...";
			this.BrowseButton.Click += new System.EventHandler(this.BrowseButton_Click);
			// 
			// OKButton
			// 
			this.OKButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.OKButton.Location = new System.Drawing.Point(200, 128);
			this.OKButton.Name = "OKButton";
			this.OKButton.TabIndex = 11;
			this.OKButton.Text = "OK";
			// 
			// FormCancelButton
			// 
			this.FormCancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.FormCancelButton.Location = new System.Drawing.Point(112, 128);
			this.FormCancelButton.Name = "FormCancelButton";
			this.FormCancelButton.TabIndex = 12;
			this.FormCancelButton.Text = "Cancel";
			// 
			// ResourceTextBox
			// 
			this.ResourceTextBox.Location = new System.Drawing.Point(96, 24);
			this.ResourceTextBox.Name = "ResourceTextBox";
			this.ResourceTextBox.ReadOnly = true;
			this.ResourceTextBox.Size = new System.Drawing.Size(176, 20);
			this.ResourceTextBox.TabIndex = 13;
			this.ResourceTextBox.Text = "";
			// 
			// PropertiesForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(362, 165);
			this.Controls.Add(this.ResourceTextBox);
			this.Controls.Add(this.FormCancelButton);
			this.Controls.Add(this.OKButton);
			this.Controls.Add(this.BrowseButton);
			this.Controls.Add(this.LocalResourceTextBox);
			this.Controls.Add(this.ActionComboBox);
			this.Controls.Add(this.StatusValueLabel);
			this.Controls.Add(this.LocalResourceLabel);
			this.Controls.Add(this.ActionLabel);
			this.Controls.Add(this.StatusLabel);
			this.Controls.Add(this.ResourceLabel);
			this.Controls.Add(this.RecordIdentifierValueLabel);
			this.Controls.Add(this.RecordIdentifierLabel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "PropertiesForm";
			this.Text = "Resource Properties";
			this.ResumeLayout(false);

		}
		#endregion

		private void BrowseButton_Click(object sender, System.EventArgs e)
		{
			if (openFileDialog.ShowDialog(this) == DialogResult.OK)
				LocalResourceTextBox.Text = openFileDialog.FileName;
		}

		private void LocalResourceTextBox_TextChanged(object sender, System.EventArgs e)
		{
			if (LocalResourceTextBox.Text.Length > 0)
				ActionComboBox.SelectedItem = "Upload";
			else
				ActionComboBox.SelectedItem = "None";
		}
	}
}
