#region License
// Copyright (c) 2005 Griffin Caprio & Choy Rim. All rights reserved.
#endregion
#region Imports
using System;

using NUnit.Framework;
#endregion

namespace DotNetMock.Examples.CustomExpectation
{
	[TestFixture]
	public class ExpectationPersonTests
	{
		private ExpectationPerson _expectationPerson = null;
		private Person _actualPerson = null;
		private Person _expectedPerson = null;

		[SetUp]
		public void Init()
		{
			_expectationPerson = new ExpectationPerson( "ExpectationPersonTests.ExpectationPerson" );
			_actualPerson = new Person( "Bobby Fake", 35 );
			_expectedPerson = new Person( "Bobby Fake", 35 );		
		}
		[TearDown]
		public void Destroy()
		{
			_expectationPerson = null;
			_actualPerson = null;
			_expectedPerson = null;
		}
		[Test]
		public void ExpectedPersonEqual()
		{
			_expectationPerson.Expected = _expectedPerson;
			Assertion.Assert( _expectationPerson.HasExpectations );
			_expectationPerson.Actual = _actualPerson;
			_expectationPerson.Verify();
		}
		[Test]
		public void ExpectedPersonFailure()
		{
			Person thirdWheel = new Person( "Bob De Niro", 56 );
			_expectationPerson.Actual = _actualPerson;
			_expectationPerson.Expected = thirdWheel;

			try 
			{
				_expectationPerson.Verify();
				Assertion.Fail( "Should throw exception" );
			}
			catch
			{

			}
			_expectationPerson.Expected = _expectedPerson;
			_expectationPerson.Verify();
		}
		[Test]
		public void ExpectationPersonActual()
		{
			Assertion.AssertNull( "Actual person", _expectationPerson.Actual );
			_expectationPerson.Actual = _actualPerson;
			Assertion.AssertNotNull( "Actual Person not null", _expectationPerson.Actual );
			Assertion.AssertEquals( "People not equal", _actualPerson, _expectationPerson.Actual );
			_expectationPerson.ClearActual();
			Assertion.AssertNull( "Actual person null", _expectationPerson.Actual );
		}
		[Test]
		public void ExpectationPersonExpected()
		{
			Assertion.AssertNull( "Expected person", _expectationPerson.Expected );
			_expectationPerson.Expected = _expectedPerson;
			Assertion.AssertNotNull( "Expected Person not null", _expectationPerson.Expected );
			Assertion.AssertEquals( "People not equal", _expectedPerson, _expectationPerson.Expected );
			_expectationPerson.ClearExpected();
			Assertion.AssertNull( "Expected person null", _expectationPerson.Expected );
		}
	}
}
