using System;
using DotNetMock;
using System.Security.Principal;

namespace DotNetMock.Framework.Security.Principal
{
	/// <summary>
	/// MockObject implementing the IIdentity interface.  Since the IIdentity interface only includes getters,
	/// this MockObject does not do much.
	/// </summary>
	public class MockIIdentity : MockObject, IIdentity
	{
		/// <summary>
		/// The expected AuthenticationType
		/// </summary>
		private string _expectedAuthType = "";
		/// <summary>
		/// The expected Name
		/// </summary>
		private string _expectedName = "";
		/// <summary>
		/// The expected value for IsAuthenticated
		/// </summary>
		private bool _expectedIsAuth = false;
		/// <summary>
		/// Default Constructor
		/// </summary>
		public MockIIdentity() : base("MockIdentity")
		{
		}
		#region Mock Methods
		/// <summary>
		/// Sets the expected AuthenticationType value to return
		/// </summary>
		/// <param name="authType">Authentication Type to return</param>
		public void SetExpectedAuthenticationType( string authType ) 
		{
			_expectedAuthType = authType;	
		}
		/// <summary>
		/// Sets the expected IsAuthenticated value to return
		/// </summary>
		/// <param name="isAuth">IsAuthenticated value to return</param>
		public void SetExpectedIsAuthenticated( bool isAuth ) 
		{
			_expectedIsAuth = isAuth;
		}
		/// <summary>
		/// Sets the expected Name value to return
		/// </summary>
		/// <param name="name">Name value to return</param>
		public void SetExpectedName( string name ) 
		{
			_expectedName = name;
		}
		#endregion
		#region Implementation of IIdentity
		/// <summary>
		/// Returns true/false if the current Identity is Authenticated or not
		/// </summary>
		public bool IsAuthenticated
		{
			get
			{
				return _expectedIsAuth;
			}
		}
		/// <summary>
		/// Returns the name of the current Identity
		/// </summary>
		public string Name
		{
			get
			{
				return _expectedName;
			}
		}
		/// <summary>
		/// Returns the current Authentication Type
		/// </summary>
		public string AuthenticationType
		{
			get
			{
				return _expectedAuthType;
			}
		}
		#endregion
	}
}
