#region License
// Copyright (c) 2004 Choy Rim. All rights reserved.
#endregion
#region Imports
using NUnit.Framework;

using DotNetMock.Dynamic;
using DotNetMock.Dynamic.Predicates;
#endregion

namespace DotNetMock.Tests.Dynamic
{
	[TestFixture]
	public class PredicateUtilsTests 
	{
		[Test] public void PredicateRemainsPredicate() 
		{
			IPredicate predicate = PredicateUtils.ConvertFrom(new IsAnything());
			Assert.IsTrue(predicate is IsAnything);
		}
		[Test] public void NullConvertedToIsAnything() 
		{
			IPredicate predicate = PredicateUtils.ConvertFrom(null);
			Assert.IsTrue(predicate is IsAnything);
		}
		[Test] public void DefaultConvertedToIsAnything() 
		{
			IPredicate predicate = PredicateUtils.ConvertFrom("whatever");
			Assert.IsTrue(predicate is IsEqual);
			Assert.IsTrue(predicate.Eval("whatever"));
		}
	}
}
