using NUnit.Framework;
namespace DotNetMock.Tests
{
	[TestFixture]
	public class ExpectationArrayTests
	{
		private ExpectationArray _expectationArray = null;
		[SetUp]
		public void Init( )
		{
			_expectationArray = new ExpectationArray( "My Expectation Array" );
		}
		[TearDown]
		public void Destroy( )
		{
			_expectationArray = null;
		}
		[Test]
		public void Empty( )
		{
			_expectationArray.Verify( );
		}
		[Test]
		public void HasExpectations( )
		{
			Assert.IsTrue( !_expectationArray.HasExpectations, "Should not have expectations." );
			_expectationArray.Expected = new object[] {"a"};
			Assert.IsTrue( _expectationArray.HasExpectations, "Should have expectations." );
		}
		[Test]
		public void HasExpectationsFromArray( )
		{
			object[] objects = new object[] {"a", "b", "c"};
			Assert.IsTrue( !_expectationArray.HasExpectations, "Should not have expectations." );
			_expectationArray.Expected = objects;
			Assert.IsTrue( _expectationArray.HasExpectations, "Should have expectations." );
		}
		[Test]
		public void HasNoExpectations( )
		{
			_expectationArray.Expected = new object[] {"a"};
			_expectationArray.ClearExpected( );
			Assert.IsTrue( !_expectationArray.HasExpectations, "Should not have expectations." );
		}
		[Test]
		public void VerfyLotsOfAdds( )
		{
			object[] objects1 = new object[] {3, 4, 5};
			object[] objects2 = new object[] {6, 7, 8};
			object[] objects3 = new object[] {3, 4, 5};
			_expectationArray.Expected = objects2;
			_expectationArray.Actual = objects1;
			try
			{
				_expectationArray.Verify( );
				Assert.Fail( "Should have thrown an exception." );
			}
			catch
			{
			}
			_expectationArray.ClearExpected( );
			_expectationArray.Expected = objects3;
			_expectationArray.Verify( );
		}
		[Test]
		[ExpectedException( typeof ( AssertionException ) )]
		public void FailImmediately( )
		{
			_expectationArray.Expected = new object[] {"a", "b"};
			_expectationArray.VerifyImmediate = true;
			_expectationArray.Actual = new object[] {"a", "c"};
		}
		[Test]
		public void FlushExpected( )
		{
			_expectationArray.Expected = new object[] {"a"};
			Assert.IsTrue( _expectationArray.HasExpectations, " should have expectations" );
			_expectationArray.ExpectNothing( );
			Assert.IsTrue( _expectationArray.HasExpectations, " should have expectations" );
			_expectationArray.Actual = new object[] {"a"};
			try
			{
				_expectationArray.Verify( );
				Assert.Fail( "Should have thrown an exception" );
			}
			catch
			{
			}
		}
		[Test]
		[ExpectedException( typeof ( AssertionException ) )]
		public void FailingVerify( )
		{
			_expectationArray.Expected = new object[] {"A", "B", "C"};
			_expectationArray.Actual = new object[] {"A", "B", "B"};
			_expectationArray.Verify( );
		}
		[Test]
		public void AddSingleItem( )
		{
			int int1 = 2;
			_expectationArray.Expected = new object[] {int1};
			_expectationArray.Actual = new object[] {int1};
			_expectationArray.Verify( );
		}
		[Test]
		public void AddMany( )
		{
			string[] array = new string[3];
			array[ 0 ] = "A";
			array[ 1 ] = "B";
			array[ 2 ] = "C";
			_expectationArray.Expected = array;
			_expectationArray.Actual = array;
			_expectationArray.Verify( );
		}
		[Test]
		[ExpectedException( typeof ( AssertionException ) )]
		public void StrictAdding( )
		{
			_expectationArray.Strict = true;
			_expectationArray.Expected = new object[] {"a"};
			_expectationArray.Actual = new object[] {"a", "b"};
			_expectationArray.Verify( );
		}
		[Test]
		public void NoStrictAdding( )
		{
			_expectationArray.Expected = new object[] {"a"};
			_expectationArray.Actual = new object[] {"a", "b"};
			_expectationArray.Verify( );
		}
		[Test]
		public void NullValuesBoth( )
		{
			_expectationArray.Expected = null;
			_expectationArray.Actual = null;
			_expectationArray.Verify( );
		}
		[Test]
		[ExpectedException( typeof ( AssertionException ) )]
		public void NullValuesExpected( )
		{
			_expectationArray.Expected = null;
			_expectationArray.Actual = new object[] {"a"};
			_expectationArray.Verify( );
		}
		[Test]
		[ExpectedException( typeof ( AssertionException ) )]
		public void NullValuesActual( )
		{
			_expectationArray.Expected = new object[] {"a"};
			_expectationArray.Actual = null;
			_expectationArray.Verify( );
		}
	}
}