using Root.Reports;
using System;

// Creation date: 05.08.2002
// Checked: 30.10.2004
// Author: Otto Mayer (mot@root.ch)
// Version: 1.03

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - Otto Mayer, Stefan Spirig, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License

// as published by the Free Software Foundation, version 2.1 of the License.

// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You

// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software

// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace ReportSamples {
  /// <summary>Start Template (C# Version)</summary>
  /// <remarks>
  /// This sample code can be used as a start template.
  /// It is recommended that your report class (e.g. MyReport) has the following structure:<br></br>
  /// - class MyReport derived from class <see cref="Root.Reports.Report"/><br></br>
  /// - overridden method <see cref="StartTemplate.Create"/> that creates the contents of the report
  /// </remarks>
  public class StartTemplate : Report {
    //------------------------------------------------------------------------------------------20.03.2004
    /// <summary>Starts the "Start Template" sample.</summary>
    /// <remarks>This method serves only to start the application.</remarks>
    public static void Main() {
      RT.ViewPDF(new StartTemplate(), "StartTemplate.pdf");
    }

    //------------------------------------------------------------------------------------------20.03.2004
    /// <summary>Creates this report.</summary>
    /// <remarks>
    /// The method <see cref="Root.Reports.Report.Create"/> of class <see cref="Root.Reports.Report"/> must
    /// be overridden to create the contents of the report.
    /// </remarks>
    protected override void Create() {
      FontDef fd = new FontDef(this, FontDef.StandardFont.Helvetica);
      FontProp fp = new FontPropMM(fd, 20);
      new Page(this);
      page_Cur.AddCB_MM(80, new RepString(fp, "Start Template"));
    }
  }
}
