using System;
using System.IO;
using NUnit.Framework;

namespace Orciid.Media
{
	[TestFixture]
	public class TestMimeType
	{
		[SetUp]
		public void Setup()
		{
			MimeType.RegisterExtension("dummy", "image/dummy");		
		}
		
		[Test]
		public void TestMimeTypeMethods()
		{
			// test standard extensions
			Assert.AreEqual("image/dummy", MimeType.GetFromExtension("dummy"));
			Assert.AreEqual("image/gif", MimeType.GetFromExtension("gif"));

			// test standard mime types
			Assert.AreEqual("dummy", MimeType.GetExtension("image/dummy"));
			Assert.AreEqual("tif", MimeType.GetExtension("image/tiff"));

			// test mime type with extended info
			Assert.AreEqual("dummy", MimeType.GetExtension("image/dummy;charset=ISO-8859-1"));
		}
	}
}
