using System;
using System.Collections;
using System.IO;
using System.Data;
using System.Data.SqlClient;
using NUnit.Framework;
using Orciid.Core;

namespace webtests
{
	[TestFixture]
	public class TestPropertyRemoval
	{
		private Utilities util;

		[SetUp]
		protected void SetUp()
		{
			// current directory should be webtests/bin/Debug
			string dsdir = Path.Combine(Directory.GetCurrentDirectory(), @"..\..\datasets");

			util = new Utilities(dsdir);

			User.GetByLogin("admin", "admin").Activate(null);
		}

		[Test]
		public void CollectionDeletion()
		{
			Collection coll = new Collection();
			coll.Title = "temp_" + Guid.NewGuid().ToString();
			coll.Description = coll.Title;
			coll.ResourcePath = @"\\invalid\resourcepath";
			coll.Update();

			Properties props = Properties.GetProperties(coll);
			props.Set("dummy", "test");

			int collid = coll.ID;

			coll.Delete();

			using (DBConnection conn = DBConnector.GetConnection(true))
			{
				Query query = new Query(conn, 
					"SELECT COUNT(*) FROM Properties " +
					"WHERE ObjectType='U' AND ObjectID={objectid}");
				query.AddParam("objectid", collid);
				Assert.AreEqual(0, conn.ExecScalar(query));
			}
		}

		[Test]
		public void UserDeletion()
		{
			User user = new User();
			user.Login = "dummy";
			user.FirstName = "test";
			user.LastName = "test";
			user.Update();

			Properties props = Properties.GetProperties(user);
			props.Set("dummy", "test");

			int userid = user.ID;

			user.Delete();

			using (DBConnection conn = DBConnector.GetConnection(true))
			{
				Query query = new Query(conn, 
					"SELECT COUNT(*) FROM Properties " +
					"WHERE ObjectType='U' AND ObjectID={objectid}");
				query.AddParam("objectid", userid);
				Assert.AreEqual(0, conn.ExecScalar(query));
			}
		}
	}
}
