namespace Orciid.PageTemplate
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using Orciid.Core;

	public abstract class PageHeader : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.PlaceHolder AdditionalItems;
		protected System.Web.UI.HtmlControls.HtmlAnchor HelpLink;

		private void Page_Load(object sender, System.EventArgs e)
		{
			Control p = this.Parent;
			while (p != null && !(p is OrciidPage))
				p = p.Parent;
			OrciidPage page = p as OrciidPage;

			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			if (user != null)
			{
				Properties props = Properties.GetProperties(user);
				if (props.GetAsInt("acskipmenulink", 0) == 1 &&
					(page == null || page.HasLeftMenu()))
					AddMenuItem(page.GetLocalString(this, "SkipLinksLink", "Skip Links"), 
						"#content", "SkipLinksLink");
			}
			if (Orciid.Core.User.CurrentUser() != null)
				AddMenuItem(page.GetLocalString(this, "LogoutLink", "Log out"), "logout.aspx", "LogoutLink");
			else
				AddMenuItem(page.GetLocalString(this, "LoginLink", "Log in"), "default.aspx", "LoginLink");
			HelpLink.HRef = Page.ResolveUrl("~/help/helpfile.htm");
		}

		public void AddMenuItem(string title, string href, string id)
		{
			Control control;
			if (href.StartsWith("#"))
			{
				HtmlGenericControl a = new HtmlGenericControl("a");
				a.Attributes["class"] = "NavbarTop";
				a.Attributes["href"] = href;
				a.InnerText = title.ToUpper();
				a.ID = id;
				control = a;
			}
			else
			{
				LinkButton link = new LinkButton();
				link.CssClass = "NavbarTop";
				link.Text = title.ToUpper();
				link.CommandName = "a";
				link.CommandArgument = href;
				link.Command += new CommandEventHandler(link_Command);
				link.CausesValidation = false;
				link.ID = id;
				control = link;
			}
			HtmlTableCell td = new HtmlTableCell();
			td.Align = "middle";
			td.VAlign = "center";
			td.Controls.Add(control);
			AdditionalItems.Controls.Add(td);
			HtmlImage img = new HtmlImage();
			img.Height = 16;
			img.Width = 10;
			img.Border = 0;
			img.Src = "../images/menu/header_separator.gif";
			td = new HtmlTableCell();
			td.Align = "middle";
			td.VAlign = "center";
			td.Controls.Add(img);
			AdditionalItems.Controls.Add(td);
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		

		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void link_Command(object sender, CommandEventArgs e)
		{
			if (e.CommandName == "a")
				Response.Redirect((string)e.CommandArgument); 
		}
	}
}
