namespace Orciid.PageTemplate
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;

	public class SelectionStatus : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.LinkButton SlideshowButton;
		protected System.Web.UI.WebControls.LinkButton SelectedSlidesButton;
		protected System.Web.UI.WebControls.LinkButton ClearSelectionButton;
		protected System.Web.UI.WebControls.LinkButton AddSlidesButton;
		protected System.Web.UI.HtmlControls.HtmlImage SpanSeperatorImage;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CurrentSlideshowSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl SelectedSlidesSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CurrentSlideshowTextSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NoImagesSelectedSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NoSelectedSlidesSpan;
		
		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.SlideshowButton.Click += new System.EventHandler(this.SlideshowButton_Click);
			this.SelectedSlidesButton.Click += new System.EventHandler(this.SelectedSlidesButton_Click);
			this.ClearSelectionButton.Click += new System.EventHandler(this.ClearSelectionButton_Click);
			this.AddSlidesButton.Click += new System.EventHandler(this.AddSlidesButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.SelectionStatus_PreRender);

		}
		#endregion

		private void SlideshowButton_Click(object sender, System.EventArgs e)
		{
			int id = -1;
			try
			{
				id = (int)Session["CurrentSlideshow"];
			}
			catch
			{
			}
			if (id != -1)
				Response.Redirect(String.Format("slideshow.aspx?id={0}", id)); 
			else
				Response.Redirect("slideshows.aspx"); 
		}

		private void SelectedSlidesButton_Click(object sender, System.EventArgs e)
		{
			ArrayList selected = Session["SelectedImages"] as ArrayList;
			if (selected != null)
			{
				Session["LastSearchResult"] = new ResultPageOptions("Selected Images", null, null, (ImageIdentifier[])selected.ToArray(typeof(ImageIdentifier)));
				Response.Redirect("result.aspx"); 
			}
		}

		private void AddSlidesButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("addslides.aspx"); 
		}

		private void ClearSelectionButton_Click(object sender, System.EventArgs e)
		{
			Session["SelectedImages"] = null;
		}

		private void SelectionStatus_PreRender(object sender, System.EventArgs e)
		{
			try
			{
				Slideshow show = Slideshow.GetByID((int)Session["CurrentSlideshow"]);
				SlideshowButton.Text = show.Title;
//				SlideshowButton.Enabled = true;
//				CurrentSlideshowSpan.Visible = 
//					User.HasPrivilege(Privilege.ModifySlideshow, show);
			}
			catch
			{
//				CurrentSlideshowSpan.Visible = false;
				SlideshowButton.Text = ((PageTemplate.OrciidPage)Page).GetLocalString(
					this, "NoSlideshowSelected", "none");
//				SlideshowButton.Enabled = false;
			}

			try
			{
				ArrayList selected = (ArrayList)Session["SelectedImages"];
			
				if (selected.Count != 1)
				{
					SelectedSlidesButton.Text = String.Format(
						((PageTemplate.OrciidPage)Page).GetLocalString(
						this, "ImagesSelected", "{0} images selected"), selected.Count);
					ClearSelectionButton.Text = 
						((PageTemplate.OrciidPage)Page).GetLocalString(
						this, "ClearSelections", "Clear selections");
				}
				else
				{
					SelectedSlidesButton.Text = 
						((PageTemplate.OrciidPage)Page).GetLocalString(
						this, "ImageSelected", "1 images selected");
					ClearSelectionButton.Text = 
						((PageTemplate.OrciidPage)Page).GetLocalString(
						this, "ClearSelection", "Clear selection");
				}
				
				SelectedSlidesSpan.Visible = (selected.Count > 0);
				NoSelectedSlidesSpan.Visible = (selected.Count == 0);
			}
			catch
			{
				SelectedSlidesSpan.Visible = false;
				NoSelectedSlidesSpan.Visible = true;
			}

//			SpanSeperatorImage.Visible = CurrentSlideshowSpan.Visible && SelectedSlidesSpan.Visible;
//			this.Visible = CurrentSlideshowSpan.Visible || SelectedSlidesSpan.Visible;	
//			this.Visible = (Session["CurrentUser"] is Orciid.Core.User);
			this.Visible = ((PageTemplate.OrciidPage)Page).UserCanBuildSlideshows;
	}
}
}
