namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;
	using Orciid.PageTemplate;

	public class AttributeUserGroupProperties : OrciidUserControl
	{
		protected System.Web.UI.WebControls.DataGrid AttributeGrid;

		private AttributeBasedUserGroup usergroup;

		public AttributeBasedUserGroup DataSource
		{
			set
			{
				usergroup = value;
			}
			get
			{
				return usergroup;
			}
		}

		public override void DataBind()
		{
			if (usergroup != null)
			{
                ArrayList attributes = new ArrayList();
				attributes.AddRange(usergroup.GetEntries());
				attributes.Add(new AttributeBasedUserGroup.AttributeEntry());
				AttributeGrid.DataSource = attributes;
				AttributeGrid.EditItemIndex = attributes.Count - 1;
			}
			else
			{
				AttributeGrid.DataSource = null;
			}
			AttributeGrid.DataBind();
		}
		
		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				if (ViewState["usergroup"] is Int32)
					usergroup = (AttributeBasedUserGroup)UserGroup.GetByID((int)ViewState["usergroup"]);
			}
		}

		protected override object SaveViewState()
		{
			if (usergroup != null)
				ViewState["usergroup"] = usergroup.ID;
			else
				ViewState["usergroup"] = null;
			return base.SaveViewState();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.AttributeGrid.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.RangeGrid_UpdateCommand);
			this.AttributeGrid.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.RangeGrid_DeleteCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void RangeGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (usergroup != null)
			{
				AttributeBasedUserGroup.AttributeEntry entry = usergroup.GetEntries()[e.Item.ItemIndex];
				usergroup.Remove(entry.Attribute);
				DataBind();
			}
		}

		private void RangeGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (usergroup != null)
			{
				string attribute = ((TextBox)e.Item.Cells[0].FindControl("attribute")).Text;
				string values = ((TextBox)e.Item.Cells[1].FindControl("values")).Text;
				try
				{
					usergroup.Add(attribute, values.Split(new char[] { '\n', '\r' }));
					DataBind();
				}
				catch
				{
					ShowError("AttributeAdditionFailed", "Could not add specified attribute condition");
				}
			}
		}
	}
}
