namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;
	using Orciid.PageTemplate;

	public class IPUserGroupProperties : OrciidUserControl
	{
		protected System.Web.UI.WebControls.DataGrid RangeGrid;

		private IPBasedUserGroup usergroup;

		public IPBasedUserGroup DataSource
		{
			set
			{
				usergroup = value;
			}
			get
			{
				return usergroup;
			}
		}

		public override void DataBind()
		{
			if (usergroup != null)
			{
				ArrayList ranges = new ArrayList();
				ranges.AddRange(usergroup.GetEntries());
				ranges.Add(new IPBasedUserGroup.RangeEntry());
				RangeGrid.DataSource = ranges;
				RangeGrid.EditItemIndex = ranges.Count - 1;
			}
			else
			{
				RangeGrid.DataSource = null;
			}
			RangeGrid.DataBind();
		}
		
		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				if (ViewState["usergroup"] is Int32)
					usergroup = (IPBasedUserGroup)UserGroup.GetByID((int)ViewState["usergroup"]);
			}
		}

		protected override object SaveViewState()
		{
			if (usergroup != null)
				ViewState["usergroup"] = usergroup.ID;
			else
				ViewState["usergroup"] = null;
			return base.SaveViewState();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.RangeGrid.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.RangeGrid_UpdateCommand);
			this.RangeGrid.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.RangeGrid_DeleteCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void RangeGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (usergroup != null)
			{
				IPBasedUserGroup.RangeEntry entry = usergroup.GetEntries()[e.Item.ItemIndex];
				usergroup.Remove(entry.Subnet, entry.Mask);
				DataBind();
			}
		}

		private void RangeGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (usergroup != null)
			{
				string subnet = ((TextBox)e.Item.Cells[0].FindControl("subnet")).Text;
				string mask = ((TextBox)e.Item.Cells[1].FindControl("mask")).Text;
				try
				{
					usergroup.Add(subnet, mask);
					DataBind();
				}
				catch (CoreException)
				{
					ShowError("InvalidInputWarning", "Invalid Network or Mask specification");
				}
			}
		}
	}
}
