namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;
	using Orciid.PageTemplate;

	public class ImageRecordDisplay : OrciidUserControl
	{
		public struct DataEntry
		{
			public readonly string Label;
			public readonly string Value;
			public readonly bool EncodeValue;

			public DataEntry(string label, string val, bool encode)
			{
				Label = label;
				Value = val;
				EncodeValue = encode;
			}

			public string GetLabel()
			{
				return HttpUtility.HtmlEncode(Label);
			}

			public string GetValue()
			{
				return EncodeValue ?
					HttpUtility.HtmlEncode(Value) :
					Value;
			}
		}


		protected System.Web.UI.WebControls.Repeater FieldRepeater;

		private string labelstyle = "font-weight: bold;";
		private string valuestyle = "";
		private object datasource = null;
		private ViewMode viewmode = ViewMode.Long;
		private ArrayList extrainfo = null;

		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		public override void DataBind()
		{
			Orciid.Core.Image image = datasource as Orciid.Core.Image;
			if (image != null)
			{
				ArrayList data = new ArrayList();
				data.Add(new DataEntry(
					GetLocalString("Collection", "Collection"), 
					image.GetCollectionTitle(),
					true));
				foreach (Field f in image.GetFields())
				{
					string label = f.Label;
					foreach (string s in image.GetDisplayValues(f, viewmode, "..."))
					{
						data.Add(new DataEntry(label, s, true));
					}
				}
				if (extrainfo != null)
					foreach (object o in extrainfo)
						if (o is DataEntry)
							data.Add(o);
				FieldRepeater.DataSource = data;
				FieldRepeater.DataBind();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		

		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		public string LabelStyle
		{
			get
			{
				return labelstyle;
			}
			set
			{
				labelstyle = (value == null ? "" : value);
			}
		}

		public string ValueStyle
		{
			get
			{
				return valuestyle;
			}
			set
			{
				valuestyle = (value == null ? "" : value);
			}
		}

		public virtual object DataSource
		{
			get
			{
				return datasource;
			}
			set
			{
				datasource = value;
			}
		}

		public ViewMode ViewMode
		{
			get
			{
				return viewmode;
			}
			set
			{
				viewmode = value;
			}
		}

		public ArrayList ExtraInfo
		{
			set
			{
				extrainfo = value;
			}
		}

	}
}
