namespace Orciid.UserControls
{
	using System;
	using System.Collections;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using Orciid.Core;

	public class MemberUserGroupProperties : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.ListBox MembersListBox;
		protected System.Web.UI.WebControls.Button RemoveButton;
		protected Orciid.UserControls.UserSelection UserSelectionControl;
		protected System.Web.UI.WebControls.Button UpdateButton;
		protected System.Web.UI.WebControls.CheckBox AnonymousUserCheckBox;
		protected System.Web.UI.HtmlControls.HtmlGenericControl CurrentMembersHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddRemoveMembersHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl GuestUserHeading;

		private MemberUserGroup usergroup;

		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		public MemberUserGroup DataSource
		{
			set
			{
				usergroup = value;
			}
			get
			{
				return usergroup;
			}
		}

		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				if (ViewState["usergroup"] is Int32)
					usergroup = (MemberUserGroup)UserGroup.GetByID((int)ViewState["usergroup"]);
			}
		}

		protected override object SaveViewState()
		{
			if (usergroup != null)
				ViewState["usergroup"] = usergroup.ID;
			else
				ViewState["usergroup"] = null;
			return base.SaveViewState();
		}

		public override void DataBind()
		{
			if (usergroup != null)
			{
				SortedList users = new SortedList();
				foreach (Orciid.Core.User u in usergroup.GetUsers())
				{
					string entry = String.Format("{0} ({1})", u.Login, u.FullName);
					int unique = 0;
					string s;
					do
					{
						s = entry + (unique == 0 ? "" : " [" + unique.ToString() + "]");
						unique++;
					} while (users.ContainsKey(s));
					users.Add(s, u.ID);
				}
				MembersListBox.DataSource = users;
				MembersListBox.DataTextField = "Key";
				MembersListBox.DataValueField = "Value";
				UserSelectionControl.DataSource = usergroup.GetUserIDs();
			}
			else
			{
				MembersListBox.DataSource = null;
				UserSelectionControl.DataSource = null;

			}
			MembersListBox.DataBind();
			UserSelectionControl.DataBind();

		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.RemoveButton.Click += new System.EventHandler(this.RemoveButton_Click);
			this.UpdateButton.Click += new System.EventHandler(this.UpdateButton_Click);
			this.AnonymousUserCheckBox.CheckedChanged += new System.EventHandler(this.AnonymousUserCheckBox_CheckedChanged);
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.MemberUserGroupProperties_PreRender);

		}
		#endregion

		private void RemoveButton_Click(object sender, System.EventArgs e)
		{
			if (usergroup != null)
			{
				foreach (ListItem item in MembersListBox.Items)
					if (item.Selected)
						usergroup.Remove(Int32.Parse(item.Value));
				DataBind();
			}
		}

		private void UpdateButton_Click(object sender, System.EventArgs e)
		{
			if (usergroup != null)
			{
				int[] current = usergroup.GetUserIDs();
				Array.Sort(current);
				int[] selected = UserSelectionControl.GetSelection();
				Array.Sort(selected);
				// find users currently in usergroup that are not selected
				foreach (int u in current)
					if (Array.BinarySearch(selected, u) < 0)
						usergroup.Remove(u);
				// find selected users that are not currently in usergroup
				foreach (int u in selected)
					if (Array.BinarySearch(current, u) < 0)
						usergroup.Add(u);
				DataBind();
			}
		}

		private void AnonymousUserCheckBox_CheckedChanged(object sender, System.EventArgs e)
		{
			CheckBox checkbox = sender as CheckBox;
			if (checkbox.Checked)
			{
				if (!usergroup.HasMember(AnonymousUser.User))
					usergroup.Add(AnonymousUser.User);
			}
			else
			{
				if (usergroup.HasMember(AnonymousUser.User))
					usergroup.Remove(AnonymousUser.User);
			}
			DataBind();
		}

		private void MemberUserGroupProperties_PreRender(object sender, System.EventArgs e)
		{
			AnonymousUserCheckBox.Checked = usergroup.HasMember(AnonymousUser.User);
		}
	}
}
