using System;
using System.Web.UI;
using Orciid.Core;
using Orciid.PageTemplate;

namespace Orciid.UserControls
{
	public class OrciidUserControl: System.Web.UI.UserControl
	{
		private OrciidPage orciidpage = null;

		private OrciidPage GetOrciidPage()
		{
			if (orciidpage != null)
				return orciidpage;
			Control control = this;
			do
			{
				control = control.Parent;
				if (control is PageTemplate.OrciidPage)
					orciidpage = (OrciidPage)control;
			} while (control != null && orciidpage == null);
			return orciidpage;
		}

		public string GetLocalString(string id, string s)
		{
			OrciidPage p = GetOrciidPage();
			if (p != null)
				return p.GetLocalString(this, id, s);
			else
				return s;
		}

		public void ShowError(string id, string s)
		{
			OrciidPage p = GetOrciidPage();
			if (p != null)
				p.ShowError(p.GetLocalString(this, id, s));
		}

		public string GetPrivilegeLabel(Privilege p)
		{
			OrciidPage page = GetOrciidPage();
			if (page != null)
			{
				string id = "Privilege_" + p.ToString();
				return page.GetLocalString(null, id, p.ToString());
			}
			else
				return p.ToString();
		}
	}
}
