using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class announcements : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Repeater AnnouncementRepeater;
		protected System.Web.UI.WebControls.Panel AddAnnouncementPanel;
		protected System.Web.UI.WebControls.Button AddAnnouncementButton;
		protected System.Web.UI.WebControls.TextBox TitleTextBox;
		protected System.Web.UI.WebControls.TextBox TextTextBox;
		protected System.Web.UI.WebControls.TextBox LinkTitleTextBox;
		protected System.Web.UI.WebControls.RequiredFieldValidator TitleRequiredFieldValidator;
		protected System.Web.UI.WebControls.RequiredFieldValidator TextRequiredFieldValidator;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddAnnouncementHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl TitleSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl TextSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl LinkTitleSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl LinkTitleOptionalSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl LinkUrlSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl LinkUrlOptionalSpan;
		protected System.Web.UI.WebControls.HyperLink ContinueHyperLink;
		protected System.Web.UI.WebControls.TextBox LinkUrlTextBox;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				DataBindAnnouncementRepeater();
				AddAnnouncementPanel.Visible = 
					Orciid.Core.User.HasPrivilege(Privilege.ManageAnnouncements);
				
				string cont = Request.QueryString["continue"];
				if (cont != null && cont.Length > 0)
				{
					ContinueHyperLink.Visible = true;
					ContinueHyperLink.NavigateUrl = cont + ".aspx";
				}
				else
					ContinueHyperLink.Visible = false;
			}
		}

		private Orciid.Core.User[] users;

		private void DataBindAnnouncementRepeater()
		{
			Announcement[] announcements = Announcement.GetAnnouncements();
#if DEMO
#warning Compiling for Demo site
			Announcement demo = new Announcement();
			demo.userid = 1;
			demo.posted = new DateTime(2004, 10, 1, 13, 0, 0);
			demo.title = "Things to know about this demo";
			demo.text = @"
<ul>
<li>
Using your demo account you can try out all of the browser-based functions 
available to a typical instructor including searching image collections, 
creating slideshows, viewing slideshows, uploading images to a personal 
collection, and packaging slideshows for offline viewing.</li>
<li>
Your demo account will expire after seven days of inactivity. You can request a 
new demo account from the login page if you need access again.</li>
<li>
The browser-based slideshow viewer in this demo has been set to display images 
in a medium-sized format of 800x800 pixels or smaller.</li>
<li>
The single image download and slideshow package download in this demo have been 
set to use larger images, if available. The AICT and Saskia sample collections 
provide larger size images up to 3000x3000 pixels.</li>
<li>
Your demo account will be limited to uploading twenty images to your personal 
collection.</li>
<li>
Other demo users will be able to see your name listed as a slideshow author and 
will be able to view any slideshows that you create and un-archive.</li>
<li>
The demo does not include the MDID ImageViewer, which is a separate application 
for presenting full screen slideshows in the classroom.</li>
<li>
The demo also does not include collection administration functions related to 
setting up collections and adding images and cataloging data, or system 
administration functions related to implementing and configuring the system.</li>
</ul>
			";
			Announcement demo2 = new Announcement();
			demo2.userid = 1;
			demo2.posted = new DateTime(2004, 10, 1, 13, 0, 0);
			demo2.title = "Things to try in this demo";
			demo2.text = @"
<P>We suggest printing this page as a quick guide tour to get started, or you can 
come back to this page at any time by clicking on Announcements.</P>
<P><STRONG>View a Slideshow</STRONG>: Click Slideshows under Resources then click 
on a slideshow listed under&nbsp;Aaron, John. Note the controls for moving 
through the show, zooming (for larger images), and split screen.</P>
<P><STRONG>Search Collections</STRONG>: Click Search under Resources then 
checkmark one or more image collections to search. A search on the keyword 
Egypt will bring up results in the AICT, Madison Art, and Saskia collections. 
As you scroll through the search results checkmark the Selected box under some 
of the images to be put into a slideshow.</P>
<P><STRONG>Create a Slideshow</STRONG>: Once you have selected some images, click 
Add Selected Images to Slideshow on the orange toolbar. Type a title for your 
new slideshow in the box and click the Create and Add Images button. Now click 
the Light Table link to arrange and annotate your slides. When you are finished 
arranging your slideshow, click the Leave the Light Table button.</P>
<P><STRONG>My Slideshows</STRONG>: Once you have created a slideshow there are 
several functions you can try from the Slideshow Properties page. Click on My 
Slideshows under My MDID then click on the Properties link next to a slideshow.</P>
<ul>
<li>
Click the Unarchive link to make your slideshow available to other users to 
view.
<li>
Click the Flash Cards link to see a PDF file formatted for cutting and folding 
into review flash cards.
<li>
Click the Add Images link to find more images to add to your slideshow.
<li>
Click the Package link to create a package of files on your computer that 
includes your slideshow images and the Flash viewer. Once the package is 
created, click on either the flasherview.exe file (for Windows) or the 
flashviewer_mac.hqx (for Mac) to view the slideshow. The package feature allows 
you to present a slideshow when you do not have a network connection available 
to the MDID server.</li>
</ul>
<P><STRONG>My Favorites</STRONG>: When viewing search or browse results you can 
checkmark the favorite box under images that you want to remember as a 
favorite. Click on My Favorites under My MDID to view the images you have 
marked as favorites. My Favorites can also be searched like any other 
collection.</P>
<P><STRONG>Personal Collection</STRONG>: You can upload your own images to MDID. 
Click on Personal Collection under My MDID. Enter a title for your image and 
click the Create button. Enter as much, or as little, cataloging data as you 
wish. Scroll to the bottom and click the Browse button to browse to an image on 
your computer then click Save Changes. Now click on View Your Personal Images 
to see that the image has been added to your personal collection. You can mark 
your personal collection images to be shared with other users. The Personal 
Images Collection, including your own personal images and any personal images 
that other users have marked to share, can be searched like any other 
collection. In this demo, you are limited to adding only twenty personal 
images.</P>
<P><STRONG>Options</STRONG>: Click on Options under My MDID to see the ways you 
can customize the interface and defaults.</P>
			";
			ArrayList temp = new ArrayList();
			temp.Add(demo);
			temp.Add(demo2);
			temp.AddRange(announcements);
			announcements = (Announcement[])temp.ToArray(typeof(Announcement));
#endif
			ArrayList ids = new ArrayList();
			foreach (Announcement a in announcements)
				if (!ids.Contains(a.UserID))
					ids.Add(a.UserID);
			users = Orciid.Core.User.GetByID((int[])ids.ToArray(typeof(int)));
			AnnouncementRepeater.DataSource = announcements;
			AnnouncementRepeater.DataBind();
		}

		public override string GetHighlightedMenuItem()
		{
			return "Information_Announcements";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return true;
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.AnnouncementRepeater.ItemDataBound += new System.Web.UI.WebControls.RepeaterItemEventHandler(this.AnnouncementRepeater_ItemDataBound);
			this.AnnouncementRepeater.ItemCommand += new System.Web.UI.WebControls.RepeaterCommandEventHandler(this.AnnouncementRepeater_ItemCommand);
			this.AddAnnouncementButton.Click += new System.EventHandler(this.AddAnnouncementButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void AnnouncementRepeater_ItemDataBound(object sender, System.Web.UI.WebControls.RepeaterItemEventArgs e)
		{
			RepeaterItem item = e.Item;
			Announcement ann = (Announcement)item.DataItem;
			Label titlelabel = item.FindControl("TitleLabel") as Label;
			if (titlelabel != null)
				titlelabel.Text = ann.Title;
			Label textlabel = item.FindControl("TextLabel") as Label;
			if (textlabel != null)
				textlabel.Text = ann.Text;
			Label authorlabel = item.FindControl("AuthorLabel") as Label;
			if (authorlabel != null)
			{
				string username = "unknown";
				if (users != null)
					foreach (Orciid.Core.User user in users)
						if (user != null && ann.UserID == user.ID)
						{
							username = user.FullName;
							break;
						}
				authorlabel.Text = String.Format(
					GetLocalString(this, "PostedBy", "Posted by {0} on {1}"),
					username, ann.Posted);
			}
			HyperLink link = item.FindControl("LinkHyperLink") as HyperLink;
			if (link != null)
			{
				if (ann.LinkTitle != null && ann.LinkUrl != null)
				{
					link.NavigateUrl = ann.LinkUrl;
					link.Text = ann.LinkTitle;
				}
				else
					link.Visible = false;
			}
			LinkButton delete = item.FindControl("DeleteLinkButton") as LinkButton;
			if (delete != null)
			{
				delete.Visible = Orciid.Core.User.HasPrivilege(Privilege.ManageAnnouncements);
				delete.CommandArgument = ann.ID.ToString();
			}
		}

		private void AddAnnouncementButton_Click(object sender, System.EventArgs e)
		{
			if (IsValid)
			{
				string linktitle = LinkTitleTextBox.Text;
				string linkurl = LinkUrlTextBox.Text;
				if (linktitle == null || linktitle.Length == 0 ||
					linkurl == null || linkurl.Length == 0)
				{
					linktitle = null;
					linkurl = null;
				}
				Announcement.AddAnnouncement(TitleTextBox.Text, TextTextBox.Text,
					linkurl, linktitle);
				DataBindAnnouncementRepeater();
			}
		}

		private void AnnouncementRepeater_ItemCommand(object source, System.Web.UI.WebControls.RepeaterCommandEventArgs e)
		{
			Announcement.DeleteAnnouncement(Int32.Parse((string)e.CommandArgument));
			DataBindAnnouncementRepeater();
		}
	}
}
