using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace orciid.imgview
{
	/// <summary>
	/// Summary description for getslides.
	/// </summary>
	public class getslides : System.Web.UI.Page
	{
		protected string NewLine(string s) 
		{
			if (s == null || s.Length < 1) return "";
			string t = "";
			char c;
			for(int i = 0; i < s.Length; i++) 
			{
				c = char.Parse(s.Substring(i, 1));
				if (c == 0xD) t = t + "\\n"; else if (c != 0xA) t = t + s.Substring(i, 1);
			}
			return t;
		}
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			string tokenkey = "";
			bool tokenisvalid = false;
			try 
			{
				tokenkey = "IVtoken" + Request.QueryString.GetValues("t")[0].ToString();
				foreach(string item in Application.Contents) 
				{
					if (item == tokenkey) 
					{
						if (DateTime.Compare(((Token)Application.Get(item)).timestamp, DateTime.Now) >= 0) 
						{
							tokenisvalid = true;
							Token token = (Token)Application.Get(item);
							token.timestamp = DateTime.Now + System.TimeSpan.FromMinutes(60);
							Application.Set(tokenkey, token);
						}
						break;
					}
				}
				if (!tokenisvalid) 
				{
					Response.Status = "401 Unauthorized";
					Response.End();
				}
			} 
			catch 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
			}
			if (!tokenisvalid) 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
				return;
			}
			Response.ExpiresAbsolute = DateTime.Parse("April 5, 1994 7:01:15");
			((Token)(Application[tokenkey])).user.Activate(Request.UserHostAddress);
			int slideshowID = Int32.Parse(Request.QueryString["s"].ToString());
			Slideshow show = Slideshow.GetByID(slideshowID);
			if (show == null) 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
				return;
			}
			Slide[] slides = show.GetSlides();
			if (slides == null || slides.Length == 0) 
			{
				Response.Write("\r\n");
				Response.End();
				return;
			}
			ImageIdentifier[] imageIDs = new ImageIdentifier[slides.Length];
			for(int i=0; i<slides.Length; i++) 
			{
				imageIDs[i] = slides[i].ImageID;
			}
			Orciid.Core.Image[] images = Orciid.Core.Image.GetByID(imageIDs);
			//ArrayList imageinfolist = new ArrayList(images.Length);
			Collection coll;
			string imageid, title, catalogdata, annotation;
			long imagesize;
			for(int i=0; i < slides.Length; i++) 
			{
				if (!slides[i].Scratch) 
				{
					if (images[i] != null) 
					{
						imageid = images[i].Resource.Substring(0, images[i].Resource.Length - 4);
						Response.Write(images[i].CollectionID + "_" + imageid + "\n");
						coll = Collection.GetByID(images[i].CollectionID);
						imagesize = coll.GetResourceSize(images[i].Resource,ImageSize.Full)/1024;
						//imagesize = images[i].GetImageData(ImageSize.Full).Length/1024;
						Response.Write(imagesize + "\n");
						title = "n/a";
						catalogdata = "";
						annotation = "" + slides[i].Annotation;
						if (coll != null)
						{
							foreach (Field f in coll.GetFields())
							{
								if (title == "n/a" && 
									// f.DCName could be null - fixed 1/31/05
									((f.DCName != null && f.DCName.ToLower() == "title") ||
									f.Name.ToLower() == "title" ||
									f.Label.ToLower() == "title"))
								{
									title = images[i].GetDisplayValues(f)[0];
									if (title.Length > 50) title = title.Substring(0, 50);
									// ImageViewer 1 can't handle square brackets in titles in right-click menu
									title = title.Replace("[", "(").Replace("]", ")");
								}
								foreach (string s in images[i].GetDisplayValues(f))
								{
									if (s == null || s.Length < 1) 
									{
										catalogdata += f.Label + ":\tn/a\\n";
									} 
									else 
									{
										catalogdata += f.Label + ":\t" + s + "\\n";
									}
								}
							}
						}
						if (title.Length < 1) title = "n/a";
						Response.Write(NewLine(title) + "\n");
						Response.Write(NewLine(catalogdata) + "\n");
						if (annotation.Length < 1) annotation = "n/a";
						Response.Write("Annotation:\t" + NewLine(annotation) + "\n");
					} 
					else 
					{
						Response.Write(slides[i].ImageID.CollectionID.ToString() + "_" + slides[i].ImageID.ID.ToString() + "\n");
						Response.Write("50\n");
						Response.Write("n/a\n");
						Response.Write("Collection\tn/a\n");
						Response.Write("Title:\tn/a\n");
					}
				}
			}
			Response.End();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
