using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text;
using Orciid.Core;

namespace orciid.imgview
{
	/// <summary>
	/// Summary description for login.
	/// </summary>
	public class login : System.Web.UI.Page
	{
		private void RemoveStaleTokens() 
		{
			ArrayList tokens = new ArrayList();
			foreach(string token in Application.Contents) 
			{
				if (token.StartsWith("IVtoken")) 
				{
					if (DateTime.Compare(((Token)Application.Get(token)).timestamp, DateTime.Now) < 0)
					{
						tokens.Add(token);
					}
				}
			}
			foreach(string item in tokens) 
			{
				Application.Remove(item);
			}
		}
		private long CreateToken(User user) 
		{
			RemoveStaleTokens();
			Random rnd = new Random(unchecked((int)DateTime.Now.Ticks));
			long tokenid = (long) (rnd.NextDouble() * 100000000 + 12345);
			Token token = new Token();
			token.timestamp = DateTime.Now + System.TimeSpan.FromMinutes(60);
			token.user = user;
			Application.Add("IVtoken" + tokenid, token);
			return tokenid;
		}
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			String userid;
			String password;
			try 
			{
				userid = Request.QueryString["userid"].ToString();
				password = Request.QueryString["password"].ToString();
			} 
			catch 
			{
				try 
				{
				userid = Request.Form["userid"].ToString();
				password = Request.Form["password"].ToString();
				} 
				catch 
				{
				userid = "";
				password = "";
				}
			}
			Response.Buffer = true;
			Response.ContentType = "text/html";
			Response.ContentEncoding = Encoding.ASCII;
			Response.ExpiresAbsolute = DateTime.Parse("April 5, 1994 7:01:15");
			Response.Write("1.10#1.10#");
			Response.Flush();
			if (userid.Length < 1 || password.Length < 1) 
			{
				Response.Write("-1\r\n");
			} 
			else 
			{
				Orciid.Core.User user = Orciid.Core.User.GetByLogin(userid, password);
				if (user == null) 
				{
					Response.Write("-2\r\n");
				} 
				else
				{
					if (!user.IsAuthenticated) 
					{
						Response.Write("-5\r\n");
					} 
					else 
					{
						user.Activate(Request.UserHostAddress);
						Slideshow[] shows = Slideshow.GetByUser(user.ID);
						//ImageViewer 1.10 expects archived shows to appear at end of slideshow list
						ArrayList sorted = new ArrayList();
						foreach(Slideshow show in shows)
							if (!show.ArchiveFlag) sorted.Add(show);
						foreach(Slideshow show in shows)
							if (show.ArchiveFlag) sorted.Add(show);
						//string showslist = "";
						if (shows == null || shows.Length < 1) 
						{
							Response.Write("-6\r\n");
						}
						else
						{
							Response.Write(CreateToken(user).ToString()+ "\r\n");
							Response.Flush();
							foreach(Slideshow show in sorted) 
							{
								if (show.ArchiveFlag) 
								{
									//showslist += "*";
									Response.Write("*");
									Response.Flush();
								}
								Response.Write(show.Title + "\t" + show.ID + "\r\n");
								Response.Flush();
							}
						}
					}
				}
			}
			//Response.Flush();
			Response.End();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
