using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class managefolders : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.DataGrid FolderGrid;
		protected System.Web.UI.WebControls.LinkButton CreateNewFolderButton;

		private Hashtable folderslidecount;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		private int[] folderids;

		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				if (ViewState["folderids"] is Int32[])
					folderids = (int[])ViewState["folderids"];
			}
		}

		protected override object SaveViewState()
		{
			ViewState["folderids"] = folderids;
			return base.SaveViewState();
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilege(Privilege.CreateSlideshow, user) ||
				Orciid.Core.User.HasPrivilegeOnAny('S', user, Privilege.ModifySlideshow, 
				Privilege.DeleteSlideshow, Privilege.ViewSlideshow, 
				Privilege.ModifyACL);
		}

		private void DataBindFolderGrid()
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			SortedList folders = user.GetFolders();
			folderslidecount = user.GetFolderSlideCount();
			folders.Add(GetLocalString(this, "MainFolder", "[Main]"), 0);
			FolderGrid.DataSource = folders;
			FolderGrid.DataBind();
			folderids = new int[folders.Count];
			int i = 0;
			foreach (DictionaryEntry item in folders)
				folderids[i++] = (int)item.Value;
		}

		public override string GetHighlightedMenuItem()
		{
			return "MyMDID_Slideshows";
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				DataBindFolderGrid();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.CreateNewFolderButton.Click += new System.EventHandler(this.CreateNewFolderButton_Click);
			this.FolderGrid.ItemCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.FolderGrid_ItemCommand);
			this.FolderGrid.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.FolderGrid_CancelCommand);
			this.FolderGrid.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.FolderGrid_EditCommand);
			this.FolderGrid.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.FolderGrid_UpdateCommand);
			this.FolderGrid.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.FolderGrid_DeleteCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void FolderGrid_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (e.CommandName == "SelectFolder")
			{
				Session["LastFolder"] = folderids[e.Item.ItemIndex];
				Response.Redirect("slideshows.aspx"); 
			}
		}

		private void FolderGrid_CancelCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			FolderGrid.EditItemIndex = -1;
			DataBindFolderGrid();
		}

		private void FolderGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			int folderid = folderids[e.Item.ItemIndex];
			user.DeleteFolder(folderid);
			DataBindFolderGrid();
		}

		private void FolderGrid_EditCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			FolderGrid.EditItemIndex = e.Item.ItemIndex;
			DataBindFolderGrid();
		}

		private void FolderGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			string title = ((TextBox)e.Item.Cells[0].FindControl("TitleTextBox")).Text;
			if (title.Length > 0)
			{
				try
				{
					if (folderids == null)
					{
						user.CreateFolder(title);
					}
					else
					{
						int folderid = folderids[e.Item.ItemIndex];
						user.RenameFolder(folderid, title);
					}
				}
				catch (CoreException ex)
				{
					ShowError(ex.Message);
				}
			}
			FolderGrid.EditItemIndex = -1;
			DataBindFolderGrid();
		}

		private DataGridItem GetDataGridItem(Control control)
		{
			while (!(control is DataGridItem) && control.Parent != null)
				control = control.Parent;
			return control as DataGridItem;
		}

		protected void DataBindTitleTextBox(object sender, System.EventArgs e)
		{
			TextBox control = sender as TextBox;
			DataGridItem item = GetDataGridItem(control);
			DictionaryEntry folder = (DictionaryEntry)item.DataItem;
			control.Text = (string)folder.Key;
		}

		protected void DataBindSlideshowCount(object sender, System.EventArgs e)
		{
			Label control = sender as Label;
			DataGridItem item = GetDataGridItem(control);
			DictionaryEntry folder = (DictionaryEntry)item.DataItem;
			if (folderslidecount != null && folderslidecount.ContainsKey(folder.Value))
				control.Text = folderslidecount[folder.Value].ToString();
			else
				control.Text = "-";
		}
		
		private void CreateNewFolderButton_Click(object sender, System.EventArgs e)
		{
			SortedList temp = new SortedList();
			temp.Add(GetLocalString(this, "NewFolder", "New folder"), 0);
			FolderGrid.EditItemIndex = 0;
			FolderGrid.DataSource = temp;
			FolderGrid.DataBind();
			folderids = null;
		}

	}
}
