using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class slideshowpassword : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Label SlideshowTitleLabel;
		protected System.Web.UI.WebControls.TextBox PasswordTextBox;
		protected System.Web.UI.WebControls.Button ContinueButton;
		protected System.Web.UI.WebControls.CustomValidator PasswordCustomValidator;
		protected System.Web.UI.HtmlControls.HtmlGenericControl passworddiv;
		protected System.Web.UI.HtmlControls.HtmlGenericControl notfounddiv;
		private Slideshow show;
		protected System.Web.UI.WebControls.RequiredFieldValidator PasswordRequiredFieldValidator;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DescriptionParagraph;
		protected System.Web.UI.HtmlControls.HtmlGenericControl PasswordLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NotFoundHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NotFoundParagraph;
		private string url;
	
		private string SessionKey
		{
			get
			{
				return String.Format("slideshowpassword:{0}", show.ID);
			}
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				try
				{
					show = Slideshow.GetByID(Int32.Parse(Request.QueryString["id"]));
					url = Request.QueryString["url"];
				}
				catch
				{
					show = null;
					url = null;
				}
			}
			if (show == null || url == null)
			{
				notfounddiv.Visible = true;
				passworddiv.Visible = false;
			}
			else
			{
				notfounddiv.Visible = false;
				passworddiv.Visible = true;
				SlideshowTitleLabel.Text = show.Title;
				string storedpwd = Session[SessionKey] as string;
				if (!show.IsPasswordProtected() || show.IsPasswordValid(storedpwd))
					Response.Redirect(url);
				else
					Session.Remove(SessionKey);
			}
		}

		public override string GetHighlightedMenuItem()
		{
			return null;
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return true;
		}

		protected override void LoadViewState(object savedState)
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				try
				{
					show = Slideshow.GetByID((int)ViewState["slideshowid"]);
					url = (string)ViewState["url"];
				}
				catch
				{
					show = null;
					url = null;
				}
			}
		}

		protected override object SaveViewState()
		{
			if (show == null)
				ViewState["slideshowid"] = null;
			else
				ViewState["slideshowid"] = show.ID;
			ViewState["url"] = url;
			return base.SaveViewState();
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ContinueButton.Click += new System.EventHandler(this.ContinueButton_Click);
			this.PasswordCustomValidator.ServerValidate += new System.Web.UI.WebControls.ServerValidateEventHandler(this.PasswordCustomValidator_ServerValidate);
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.slideshowpassword_PreRender);

		}
		#endregion

		private void ContinueButton_Click(object sender, System.EventArgs e)
		{
			if (IsValid)
			{
				Session[SessionKey] = PasswordTextBox.Text;
				Response.Redirect(url);
			}
		}

		private void PasswordCustomValidator_ServerValidate(object source, System.Web.UI.WebControls.ServerValidateEventArgs args)
		{
			args.IsValid = show.IsPasswordValid(args.Value);
		}

		private void slideshowpassword_PreRender(object sender, System.EventArgs e)
		{
			PasswordTextBox.Attributes.Add("onkeypress", 
				"return clickButton(event,'" + ContinueButton.ClientID + "')");
		}
	}
}
