using System;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for <see cref="Field"/> class.
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestField
	{
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests <see cref="Field.Name"/> property.
		/// </remarks>
		[Test]
		public void PaddedFieldName()
		{
			AnonymousUser.User.Activate(null);

			Field f;
			
			f = new Field();
			f.Name = "test";
			Assert.AreEqual("test", f.Name);

			f = new Field();
			f.Name = " test";
			Assert.AreEqual("test", f.Name);

			f = new Field();
			f.Name = "test ";
			Assert.AreEqual("test", f.Name);

			f = new Field();
			f.Name = "  test \t  ";
			Assert.AreEqual("test", f.Name);
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Confirms an exception is thrown if the field name is set to <c>null</c>.
		/// </remarks>
		[Test]
		[ExpectedException(typeof(CoreException))]
		public void NullFieldName()
		{
			Field f = new Field();
			f.Name = null;
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Confirms an exception is thrown if the field name is set to a blank string.
		/// </remarks>
		[Test]
		[ExpectedException(typeof(CoreException))]
		public void EmptyFieldName()
		{
			Field f = new Field();
			f.Name = "";
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Confirms an exception is thrown if the field name is set to a string
		/// consisting only of whitespace characters.
		/// </remarks>
		[Test]
		[ExpectedException(typeof(CoreException))]
		public void WhitespaceFieldName()
		{
			Field f = new Field();
			f.Name = " \t \t   ";
		}
	}
}
