using System;
using System.Collections;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for <see cref="FullTextIndex.Number"/> class.
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestFullTextIndexNumber
	{
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests <see cref="FullTextIndex.Number"/> class methods
		/// </remarks>
		[Test]
		public void ToAndFromIndex()
		{
			long[] numbers = { 
								 Int64.MinValue,
								 Int64.MinValue + 1,
								 -1,
								 0,
								 1,
								 Int64.MaxValue - 1,
								 Int64.MaxValue
							 };

			ArrayList list = new ArrayList();
			foreach (long l in numbers)
				list.Add(FullTextIndex.Number.ToIndex(l));

			for (int i = 0; i < numbers.Length; i++)
			{
				Console.WriteLine("{0} = {1}", numbers[i], list[i]);
				Assert.AreEqual(numbers[i], FullTextIndex.Number.FromIndex((string)list[i]));
			}

			for (int i = 1; i < list.Count; i++)
				Assert.Greater((string)list[i], (string)list[i - 1]);

			int length = ((string)list[0]).Length;
			for (int i = 1; i < list.Count; i++)
				Assert.AreEqual(length, ((string)list[i]).Length);
		}
	}
}
