using System;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestSearchConditions
	{
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void SplitTerms()
		{
			string[] r;
			
			r = TextCondition.SplitTermsLucene("abc");
			Assert.IsNotNull(r);
			Assert.AreEqual(1, r.Length);
			Assert.AreEqual("abc", r[0]);

			r = TextCondition.SplitTermsLucene("abc def");
			Assert.IsNotNull(r);
			Assert.AreEqual(2, r.Length);
			Assert.AreEqual("abc", r[0]);
			Assert.AreEqual("def", r[1]);

			r = TextCondition.SplitTermsLucene("\"abc def\"");
			Assert.IsNotNull(r);
			Assert.AreEqual(1, r.Length);
			Assert.AreEqual("\"abc def\"", r[0]);

			r = TextCondition.SplitTermsLucene("\"abc def\" ghi");
			Assert.IsNotNull(r);
			Assert.AreEqual(2, r.Length);
			Assert.AreEqual("\"abc def\"", r[0]);
			Assert.AreEqual("ghi", r[1]);

			r = TextCondition.SplitTermsLucene("abc \"def ghi\"");
			Assert.IsNotNull(r);
			Assert.AreEqual(2, r.Length);
			Assert.AreEqual("\"def ghi\"", r[0]);
			Assert.AreEqual("abc", r[1]);

			r = TextCondition.SplitTermsLucene("abc \"def ghi\" jkl");
			Assert.IsNotNull(r);
			Assert.AreEqual(3, r.Length);
			Assert.AreEqual("\"def ghi\"", r[0]);
			Assert.AreEqual("abc", r[1]);
			Assert.AreEqual("jkl", r[2]);

			r = TextCondition.SplitTermsLucene("+abc +\"def ghi\" +jkl");
			Assert.IsNotNull(r);
			Assert.AreEqual(3, r.Length);
			Assert.AreEqual("+\"def ghi\"", r[0]);
			Assert.AreEqual("+abc", r[1]);
			Assert.AreEqual("+jkl", r[2]);

			r = TextCondition.SplitTermsLucene("abc -\"def ghi\" -jkl");
			Assert.IsNotNull(r);
			Assert.AreEqual(3, r.Length);
			Assert.AreEqual("-\"def ghi\"", r[0]);
			Assert.AreEqual("abc", r[1]);
			Assert.AreEqual("-jkl", r[2]);

		}
	}
}
