using System;
using System.Collections;
using Orciid.Core.Util;

namespace Orciid.Core
{

	public class WebAuthUserAuthentication:
		UserAuthentication
	{
		private string username = null;
	
		public override bool Authenticate(string username, string password)
		{
			this.username = username;
			return true;
		}

		public override string GetAuthenticationType()
		{
			return "webauth";
		}

		public override string GetFirstName()
		{
			return null;
		}

		public override string GetLastName()
		{
			return username;
		}

		public override string GetEmail()
		{
			return String.Format("{0}@{1}", username, Configuration.Instance.GetString("authentication.webauth.emaildomain"));
		}

		public override string GetPassword()
		{
			return null;
		}

		public override Hashtable GetAttributes()
		{
			return null;
		}

	}
}