using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

namespace imagemanager
{
	/// <summary>
	/// Summary description for LoginForm.
	/// </summary>
	public class LoginForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button connectButton;
		private System.Windows.Forms.TextBox passwordTextBox;
		private System.Windows.Forms.Label passwordLabel;
		private System.Windows.Forms.TextBox userTextBox;
		private System.Windows.Forms.Label userLabel;
		private System.Windows.Forms.Label serverLabel;
		private System.Windows.Forms.TextBox serverUrlTextBox;
		private System.Windows.Forms.Button cancelButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public string ServerUrl
		{
			get
			{
				return serverUrlTextBox.Text;
			}
		}

		public string User
		{
			get
			{
				return userTextBox.Text;
			}
		}

		public string Password
		{
			get
			{
				return passwordTextBox.Text;
			}
		}
		
		public LoginForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.connectButton = new System.Windows.Forms.Button();
			this.passwordTextBox = new System.Windows.Forms.TextBox();
			this.passwordLabel = new System.Windows.Forms.Label();
			this.userTextBox = new System.Windows.Forms.TextBox();
			this.userLabel = new System.Windows.Forms.Label();
			this.serverLabel = new System.Windows.Forms.Label();
			this.serverUrlTextBox = new System.Windows.Forms.TextBox();
			this.cancelButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// connectButton
			// 
			this.connectButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.connectButton.Location = new System.Drawing.Point(200, 96);
			this.connectButton.Name = "connectButton";
			this.connectButton.Size = new System.Drawing.Size(72, 23);
			this.connectButton.TabIndex = 13;
			this.connectButton.Text = "Connect";
			this.connectButton.Click += new System.EventHandler(this.connectButton_Click);
			// 
			// passwordTextBox
			// 
			this.passwordTextBox.Location = new System.Drawing.Point(64, 64);
			this.passwordTextBox.Name = "passwordTextBox";
			this.passwordTextBox.PasswordChar = '*';
			this.passwordTextBox.Size = new System.Drawing.Size(208, 20);
			this.passwordTextBox.TabIndex = 12;
			this.passwordTextBox.Text = "";
			// 
			// passwordLabel
			// 
			this.passwordLabel.Location = new System.Drawing.Point(8, 64);
			this.passwordLabel.Name = "passwordLabel";
			this.passwordLabel.Size = new System.Drawing.Size(56, 16);
			this.passwordLabel.TabIndex = 11;
			this.passwordLabel.Text = "Password";
			// 
			// userTextBox
			// 
			this.userTextBox.Location = new System.Drawing.Point(64, 40);
			this.userTextBox.Name = "userTextBox";
			this.userTextBox.Size = new System.Drawing.Size(208, 20);
			this.userTextBox.TabIndex = 10;
			this.userTextBox.Text = "";
			// 
			// userLabel
			// 
			this.userLabel.Location = new System.Drawing.Point(32, 40);
			this.userLabel.Name = "userLabel";
			this.userLabel.Size = new System.Drawing.Size(32, 16);
			this.userLabel.TabIndex = 9;
			this.userLabel.Text = "User";
			// 
			// serverLabel
			// 
			this.serverLabel.Location = new System.Drawing.Point(24, 16);
			this.serverLabel.Name = "serverLabel";
			this.serverLabel.Size = new System.Drawing.Size(40, 16);
			this.serverLabel.TabIndex = 8;
			this.serverLabel.Text = "Server";
			// 
			// serverUrlTextBox
			// 
			this.serverUrlTextBox.Location = new System.Drawing.Point(64, 16);
			this.serverUrlTextBox.Name = "serverUrlTextBox";
			this.serverUrlTextBox.Size = new System.Drawing.Size(208, 20);
			this.serverUrlTextBox.TabIndex = 7;
			this.serverUrlTextBox.Text = "http://";
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(120, 96);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.Size = new System.Drawing.Size(72, 23);
			this.cancelButton.TabIndex = 14;
			this.cancelButton.Text = "Cancel";
			// 
			// LoginForm
			// 
			this.AcceptButton = this.connectButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.cancelButton;
			this.ClientSize = new System.Drawing.Size(288, 131);
			this.Controls.Add(this.cancelButton);
			this.Controls.Add(this.connectButton);
			this.Controls.Add(this.passwordTextBox);
			this.Controls.Add(this.userTextBox);
			this.Controls.Add(this.serverUrlTextBox);
			this.Controls.Add(this.passwordLabel);
			this.Controls.Add(this.userLabel);
			this.Controls.Add(this.serverLabel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "LoginForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Connect to Server";
			this.Load += new System.EventHandler(this.LoginForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void LoginForm_Load(object sender, System.EventArgs e)
		{
			RegistryKey rksoftware = null;
			RegistryKey rkmdid = null;
			RegistryKey rkim = null;
			try
			{
				rksoftware = Registry.CurrentUser.OpenSubKey("Software", true);
				rkmdid = rksoftware.OpenSubKey("Madison Digital Image Database");
				rkim = rkmdid.OpenSubKey("ImageManager");
				serverUrlTextBox.Text = rkim.GetValue("Server").ToString();
				userTextBox.Text = rkim.GetValue("User").ToString();
			}
			catch
			{
			}
			finally
			{
				if (rkim != null)
					rkim.Close();
				if (rkmdid != null)
					rkmdid.Close();
				if (rksoftware != null)
					rksoftware.Close();
			}
			if (serverUrlTextBox.Text == "")
				this.ActiveControl = serverUrlTextBox;
			else if (userTextBox.Text == "")
				this.ActiveControl = userTextBox;
			else 
				this.ActiveControl = passwordTextBox;
		}

		private void connectButton_Click(object sender, System.EventArgs e)
		{
			RegistryKey rksoftware = null;
			RegistryKey rkmdid = null;
			RegistryKey rkim = null;
			try
			{
				rksoftware = Registry.CurrentUser.OpenSubKey("Software", true);
				rkmdid = rksoftware.CreateSubKey("Madison Digital Image Database");
				rkim = rkmdid.CreateSubKey("ImageManager");
				rkim.SetValue("Server", serverUrlTextBox.Text);
				rkim.SetValue("User", userTextBox.Text);
			}
			catch
			{
			}
			finally
			{
				if (rkim != null)
					rkim.Close();
				if (rkmdid != null)
					rkmdid.Close();
				if (rksoftware != null)
					rksoftware.Close();
			}
		}
	}
}
