#region License
// Copyright (c) 2005 Griffin Caprio & Choy Rim. All rights reserved.
#endregion
#region Imports
using System;

using NUnit.Framework;
#endregion

namespace DotNetMock.Examples.Mainframe
{
	[TestFixture]
	public class SerialNumberCollectorTests
	{	
		private MockMainframeConnection mockConnection = null;
		string[,] customerNumberScreen = null;
		string[,] mainMenu = null;
		CustomerNumberCollector customer = null;

		[SetUp]
		public void Init() 
		{
			mockConnection = new MockMainframeConnection();
			customerNumberScreen = new string[25,80];
			mainMenu = new string[25,80];
			customer = new CustomerNumberCollector(mockConnection);
			mockConnection.CreateScreen("MainMenu", mainMenu);
			mockConnection.CreateScreen("CustomerInformation", customerNumberScreen);
		}
		[TearDown]
		public void Destroy() 
		{
			mockConnection = null;
			customerNumberScreen = null;
		}
		[Test]
		[ExpectedException(typeof(ApplicationException))]
		public void InValidCustomerNumber()
		{
			setGeneralExpectations();
			mockConnection.SetExpectedKeyPress(MainframeConnection.Keys.Enter);
			mockConnection.SetField("CustomerInformation", 23, 2, "CUSTOMER NUMBER NOT FOUND");
			customer.CollectCustomerInformation("9999999");
		}
		[Test]
		public void ValidCustomerNumber()
		{
			setGeneralExpectations();
			mockConnection.SetField("CustomerInformation", 20, 4, "Pete Rose");
			mockConnection.SetField("CustomerInformation", 21, 4, "pete1234");
			mockConnection.SetField("CustomerInformation", 22, 4, "password");
			mockConnection.SetExpectedKeyPress(MainframeConnection.Keys.Enter);

			customer.CollectCustomerInformation("1234567");

			Assertion.AssertEquals("Pete Rose", customer.Name);
			Assertion.AssertEquals("pete1234", customer.UserName);
			Assertion.AssertEquals("password", customer.Password);
		}
		[Test]
		public void ValidCustomerNumberUpdate() 
		{
			setGeneralExpectations();
			mockConnection.SetField("CustomerInformation", 23, 3, "TRANSACTION ACCEPTED");
			mockConnection.SetField("CustomerInformation", 20, 4, "Pete Rose");
			mockConnection.SetField("CustomerInformation", 21, 4, "pete1234");
			mockConnection.SetField("CustomerInformation", 22, 4, "password");
			mockConnection.SetExpectedKeyPress(MainframeConnection.Keys.Enter);

			customer.UpdateInformation("1234567", "Babe Ruth", "baberuth", "babepass");

			Assertion.AssertEquals("Babe Ruth", customer.Name);
			Assertion.AssertEquals("baberuth", customer.UserName);
			Assertion.AssertEquals("babepass", customer.Password);
		}
		[Test]
		[ExpectedException(typeof(ApplicationException))]
		public void InvalidCustomerUpdate() 
		{
			setGeneralExpectations();
			mockConnection.SetExpectedKeyPress(MainframeConnection.Keys.Enter);
			mockConnection.SetField("CustomerInformation", 23, 2, "TRANSACTION FAILED");
			customer.UpdateInformation("1234567", "Babe Ruth", "baberuth", "babepass");
		}
		[Test]
		[ExpectedException(typeof(ApplicationException))]
		public void InValidCustomerNumberUpdateInformation()
		{
			setGeneralExpectations();
			mockConnection.SetExpectedKeyPress(MainframeConnection.Keys.Enter);
			mockConnection.SetField("CustomerInformation", 23, 2, "CUSTOMER NUMBER NOT FOUND");
			customer.UpdateInformation("9999999", "", "", "");
		}
		private void setGeneralExpectations()
		{
			mockConnection.SetExpectedConnectCalls(1);
			mockConnection.SetExpectedDisconnectCalls(1);
			mockConnection.SetExpectedSendKeyCalls(1);
		}
	}
}
