#region License
// Copyright (c) 2004 Griffin Caprio & Choy Rim. All rights reserved.
#endregion
#region Imports
using System;
using System.Collections;

using NUnit.Framework;

using DotNetMock.Util;
#endregion

namespace DotNetMock.Tests.Util
{
	[TestFixture]
	public class StringUtilsTests 
	{
		[Test] public void FormatScalar() 
		{
			Assert.AreEqual(
				"'two'",
				StringUtils.FormatScalar("two")
				);
			Assert.AreEqual(
				"1",
				StringUtils.FormatScalar(1)
				);
			Assert.AreEqual(
				"3.4",
				StringUtils.FormatScalar(3.4)
				);
			Assert.AreEqual(
				"[1, 'two', 3.4]",
				StringUtils.FormatScalar(new object[] { 1, "two", 3.4 })
				);
		}
		[Test] public void FormatArray() 
		{
			Assert.AreEqual(
				"1, 'two', 3.4",
				StringUtils.FormatArray(1, "two", 3.4)
				);
		}
		[Test] public void FormatDictionary() 
		{
			Hashtable hash = new Hashtable();
			hash["a"]=1;
			hash["b"]="two";
			hash["c"]=3.4;
			Assert.AreEqual(
				"a=1, b='two', c=3.4",
				StringUtils.FormatCollection(hash)
				);
		}
		[Test] public void FormatCollection() 
		{
			ArrayList list = new ArrayList();
			list.Add(1);
			list.Add("two");
			list.Add(3.4);
			Assert.AreEqual(
				"1, 'two', 3.4", 
				StringUtils.FormatCollection(list)
				);
		}
	}
}
