using System;
using System.IO;

// Creation date: 22.04.2002
// Checked: xx.05.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - O. Mayer, S. Spirig, R. Gartenmann, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace Root.Reports {
  /// <summary></summary>
  public abstract class Formatter {
    /// <summary>Report to which this formatter belongs</summary>
    private Report _report;

    /// <summary>Stream to which the result must be written</summary>
    protected Stream _stream;

    //----------------------------------------------------------------------------------------------------x
    /// <summary></summary>
    protected Formatter() {
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary></summary>
    /// <param name="report"></param>
    /// <param name="stream"></param>
    public virtual void Create(Report report, Stream stream) {
      _report = report;
      _stream = stream;
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates a font properties data object for this formatter.</summary>
    /// <param name="fontProp"></param>
    /// <returns></returns>
    internal protected abstract FontPropData fontPropData_CreateInstance(FontProp fontProp);

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates a page data object for this formatter.</summary>
    /// <returns></returns>
    internal protected abstract PageData pageData_CreateInstance();

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Initializes the font definition class.</summary>
    /// <param name="fontDef"></param>
    internal protected abstract void InitFontDef(FontDef fontDef);

    //----------------------------------------------------------------------------------------------------
    /// <summary>Gets the Stream object.</summary>
    public Stream stream {
      set { _stream = value; }
      get { return _stream; }
    }
  }
}
