using System;
using System.Drawing;

namespace Orciid.Media.Converters
{
	public struct Parameters
	{
		public const int Unspecified = 0;
		public const int None = 0;
		public static readonly Parameters Default = 
			new Parameters(Unspecified, Unspecified, Unspecified);

		private int targetwidth;
		private int targetheight;
		private bool exacttargetsize;
		private Color bordercolor;
		private int cropx;
		private int cropy;
		private int cropw;
		private int croph;
		private int quality;

		public Parameters(int targetwidth, int targetheight, 
			bool exacttargetsize, Color bordercolor,
			int cropx, int cropy, int cropw, int croph,
			int quality)
		{
			this.targetwidth = targetwidth;
			this.targetheight = targetheight;
			this.exacttargetsize = exacttargetsize;
			this.bordercolor = bordercolor;
			this.cropx = cropx;
			this.cropy = cropy;
			this.cropw = cropw;
			this.croph = croph;
			this.quality = quality;
		}

		public Parameters(int targetwidth, int targetheight, 
			bool exacttargetsize, Color bordercolor,
			int quality):
			this(targetwidth, targetheight, exacttargetsize, 
			bordercolor, None, None, None, None, quality)
		{			
		}

		public Parameters(int targetwidth, int targetheight, 
			int quality):
			this(targetwidth, targetheight, false, Color.Black,
			None, None, None, None, quality)
		{
		}

		public bool WithinCapabilities(Capabilities capabilities)
		{
			if ((targetwidth != Unspecified || targetheight != Unspecified) &&
				(capabilities & Capabilities.Resize) != Capabilities.Resize)
				return false;
			if (exacttargetsize &&
				(capabilities & Capabilities.AddBorder) != Capabilities.AddBorder)
				return false;
			if ((cropx != None || cropy != None || cropw != None || croph != None) &&
				(capabilities & Capabilities.Crop) != Capabilities.Crop)
				return false;
			if ((quality != Unspecified) &&
				(capabilities & Capabilities.SetQuality) != Capabilities.SetQuality)
				return false;
			return true;
		}

		public int TargetWidth
		{
			get
			{
				return targetwidth;
			}
		}

		public int TargetHeight
		{
			get
			{
				return targetheight;
			}
		}

		public bool ExactTargetSize
		{
			get
			{
				return exacttargetsize;
			}
		}

		public Color BorderColor
		{
			get
			{
				return bordercolor;
			}
		}

		public int CropX
		{
			get
			{
				return cropx;
			}
		}

		public int CropY
		{
			get
			{
				return cropy;
			}
		}

		public int CropW
		{
			get
			{
				return cropw;
			}
		}

		public int CropH
		{
			get
			{
				return croph;
			}
		}

		public int Quality
		{
			get
			{
				return quality;
			}
		}

		public override string ToString()
		{
			return String.Format("{0}x{1}{2}{3:X2}{4:X2}{5:X2}x{6}y{7}w{8}h{9}q{10}",
				targetwidth,
				targetheight,
				exacttargetsize ? 'f' : 'v',
				bordercolor.R,
				bordercolor.G,
				bordercolor.B,
				cropx,
				cropy,
				cropw,
				croph,
				quality);			
		}
	}
}
