using System;
using System.Drawing;
using NUnit.Framework;

namespace Orciid.Media.Converters
{
	[TestFixture]
	public class TestParameters
	{
		[Test]
		public void DefaultParameters()
		{
			Parameters p = new Parameters();
			Assert.IsTrue(p.WithinCapabilities(Capabilities.None));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.AddBorder));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.Crop));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.Resize));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.SetQuality));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Crop | Capabilities.Resize |
				Capabilities.SetQuality));
		}

		[Test]
		public void ResizeParameters()
		{
			Parameters p = new Parameters(100, 100, Parameters.Unspecified);
			Assert.IsFalse(p.WithinCapabilities(Capabilities.None));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.AddBorder));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Crop));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.Resize));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.SetQuality));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Crop | Capabilities.Resize |
				Capabilities.SetQuality));
		}

		[Test]
		public void QualityParameters()
		{
			Parameters p = new Parameters(Parameters.Unspecified, Parameters.Unspecified, 100);
			Assert.IsFalse(p.WithinCapabilities(Capabilities.None));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.AddBorder));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Crop));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Resize));
			Assert.IsTrue(p.WithinCapabilities(Capabilities.SetQuality));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Crop | Capabilities.Resize |
				Capabilities.SetQuality));
		}

		[Test]
		public void BorderParameters()
		{
			Parameters p = new Parameters(100, 100, true, Color.Red, Parameters.Unspecified);
			Assert.IsFalse(p.WithinCapabilities(Capabilities.None));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.AddBorder));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Crop));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Resize));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.SetQuality));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Resize));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Crop | Capabilities.Resize |
				Capabilities.SetQuality));
		}

		[Test]
		public void CropParameters()
		{
			Parameters p = new Parameters(100, 100, false, Color.Empty, 2, 1, 4, 5, 
				Parameters.Unspecified);
			Assert.IsFalse(p.WithinCapabilities(Capabilities.None));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.AddBorder));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Crop));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.Resize));
			Assert.IsFalse(p.WithinCapabilities(Capabilities.SetQuality));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.Resize | Capabilities.Crop));
			Assert.IsTrue(p.WithinCapabilities(
				Capabilities.AddBorder | Capabilities.Crop | Capabilities.Resize |
				Capabilities.SetQuality));
		}

		[Test]
		public void ParametersProperties()
		{
			Parameters p = new Parameters(1, 2, true, Color.Red, 3, 4, 5, 6, 7);
			Assert.AreEqual(1, p.TargetWidth);
			Assert.AreEqual(2, p.TargetHeight);
			Assert.AreEqual(true, p.ExactTargetSize);
			Assert.AreEqual(Color.Red, p.BorderColor);
			Assert.AreEqual(3, p.CropX);
			Assert.AreEqual(4, p.CropY);
			Assert.AreEqual(5, p.CropW);
			Assert.AreEqual(6, p.CropH);
			Assert.AreEqual(7, p.Quality);
		}

		[Test]
		public void TestToString()
		{
			string def = Parameters.Default.ToString();
			string p1 = new Parameters(640, 480, 95).ToString();
			string p2 = new Parameters(640, 480, true, Color.BlueViolet, 95).ToString();
			string p3 = new Parameters(640, 480, true, Color.BlueViolet, 10, 20, 30, 40, 95).ToString();
			Console.WriteLine(def);
			Console.WriteLine(p1);
			Console.WriteLine(p2);
			Console.WriteLine(p3);
			Assert.IsFalse(def == p1);
			Assert.IsFalse(def == p2);
			Assert.IsFalse(def == p3);
			Assert.IsFalse(p1 == p2);
			Assert.IsFalse(p1 == p3);
			Assert.IsFalse(p2 == p3);
		}
	}
}
