using System;
using System.IO;
using System.Data;
using System.Collections;
using NUnit.Framework;
using Orciid.Core;

namespace webtests
{
	/// <summary>
	/// Tests to check for following bugs:
	/// - Collection title does not appear when viewing slideshows that contain images that
	///   current user does not have access to
	/// - Personal images that are not shared are not available to other users who also have
	///   access to personal images, even if they are in a slideshow context
	/// </summary>
	[TestFixture]
	public class TestPersonalImagePermissions
	{
//		private SqlDbUnitTest dbu;
		private Utilities util;

		private Slideshow slideshow;
		private Image image;

		private ArrayList removeusers = new ArrayList();

		[SetUp]
		protected void SetUp()
		{
			// current directory should be webtests/bin/Debug
			string dsdir = Path.Combine(Directory.GetCurrentDirectory(), @"..\..\datasets");

			util = new Utilities(dsdir);
//			dbu = new SqlDbUnitTest(util.Connection);

//			util.ResetDatabase();

			// prepare invalid FavoriteImages record
//			dbu.ReadXmlSchema(Path.Combine(dsdir, "OrciidDataset.xsd"));
//			dbu.ReadXml(Path.Combine(dsdir, "TestPersonalImagePermissions.xml"));

/*
<?xml version="1.0" standalone="yes"?>
<TestPersonalImagePermissions xmlns="http://tempuri.org/OrciidDataset.xsd">
	<Users>
		<ID>2</ID>
		<Login>fac1</Login>
		<Password>21232F297A57A5A743894A0E4A801FC3</Password>
	</Users>
	<Users>
		<ID>3</ID>
		<Login>fac2</Login>
		<Password>21232F297A57A5A743894A0E4A801FC3</Password>
	</Users>
	<Users>
		<ID>4</ID>
		<Login>stu1</Login>
		<Password>21232F297A57A5A743894A0E4A801FC3</Password>
	</Users>
	<!-- Add the two faculty accounts to the faculty group (ID 1) -->
	<UserGroupMembers>
		<UserID>2</UserID>
		<GroupID>1</GroupID>
	</UserGroupMembers>
	<UserGroupMembers>
		<UserID>3</UserID>
		<GroupID>1</GroupID>
	</UserGroupMembers>	
</TestPersonalImagePermissions>

*/

			// insert invalid record
//			dbu.PerformDbOperation(DbOperationFlag.Refresh);

			User.GetByLogin("admin", "admin").Activate(null);

			User fac1 = new User();
			fac1.Login = "fac1";
			fac1.LastName = "fac1";
			fac1.Update();
			fac1.SetPassword("fac1");
			removeusers.Add(fac1);

			User stu1 = new User();
			stu1.Login = "stu1";
			stu1.LastName = "stu1";
			stu1.Update();
			stu1.SetPassword("stu1");
			removeusers.Add(stu1);

			GetFacultyGroup().Add(fac1.ID);			
		}

		private MemberUserGroup GetFacultyGroup()
		{
			foreach (UserGroup g in UserGroup.GetUserGroups())
				if (g.Title == "Faculty" && g is MemberUserGroup)
					return g as MemberUserGroup;
			return null;
		}

		[TearDown]
		protected void TearDown()
		{			
			// remove invalid record
//			dbu.PerformDbOperation(DbOperationFlag.Delete);

			User.GetByLogin("admin", "admin").Activate(null);

			try
			{
				if (slideshow != null)
					slideshow.Delete();
			}
			catch
			{
			}

			try 
			{
				if (image != null)
					image.Delete();
			}
			catch
			{
			}

			foreach (User user in removeusers)
				user.Delete();
		}

		private Collection GetPersonalCollection()
		{
			foreach (Collection coll in Collection.GetCollections())
				if (coll.Title == "Personal Images")
					return coll;
			Assert.Fail();
			return null;
		}

		/// <summary>
		/// Check for collection title bug
		/// </summary>
		[Test]
		public void CheckCollectionTitle()
		{
			User.GetByLogin("fac1", "fac1").Activate(null);
			Collection personal = GetPersonalCollection();

			// create a personal image
			image = personal.CreateImage(true);
			image["Title"].Add("Test Image");
			image.Update();

			// put image in a new slideshow
			slideshow = new Slideshow();
			slideshow.Title = "Test Slideshow";
			Slide slide = new Slide();
			slide.ImageID = image.ID;
			slideshow.Add(slide);
			slideshow.ArchiveFlag = false;
			slideshow.Update();
			slideshow.GetAccessControl().AddUserPrivilege(Privilege.ViewSlideshow, Privilege.None,
				User.GetByLogin("stu1").ID);

			// check slideshow as student
			User.GetByLogin("stu1", "stu1").Activate(null);
			Slideshow viewshow = Slideshow.GetByID(slideshow.ID);
			Assert.IsNotNull(viewshow);
			Slide[] slides = viewshow.GetSlides();
			Image[] images = viewshow.GetImages();
			Assert.IsNotNull(images);
			Assert.IsNotNull(images[0]);
			Assert.AreEqual("Personal Images", images[0].GetCollectionTitle());
		}
	}
}
