using System;
using System.Collections;
using System.IO;
using System.Data;
using System.Data.SqlClient;
using NUnit.Framework;
using Orciid.Core;

namespace webtests
{
	[TestFixture]
	public class TestPrivileges
	{
		private ArrayList collections = new ArrayList();
		private ArrayList users = new ArrayList();
		private ArrayList usergroups = new ArrayList();
		private Utilities util;

		[SetUp]
		protected void SetUp()
		{
			// current directory should be webtests/bin/Debug
			string dsdir = Path.Combine(Directory.GetCurrentDirectory(), @"..\..\datasets");

			util = new Utilities(dsdir);

			User.GetByLogin("admin", "admin").Activate(null);
		}

		[TearDown]
		protected void TearDown()
		{
			User.GetByLogin("admin", "admin").Activate(null);

			foreach (Collection c in collections)
				if (c != null)
					c.Delete();
			foreach (User u in users)
				if (u != null)
					u.Delete();
			foreach (UserGroup ug in usergroups)
				if (ug != null)
					ug.Delete();

			collections.Clear();
			users.Clear();
			usergroups.Clear();
		}

		private Collection GetTempCollection()
		{
			Collection coll = new Collection();
			coll.Title = "temp_" + Guid.NewGuid().ToString();
			coll.Description = coll.Title;
			coll.ResourcePath = @"\\invalid\resourcepath";
			coll.Update();
			collections.Add(coll);
			return coll;
		}

		private static int usercount = 1;

		private User GetTempUser()
		{
			string id = "test" + usercount.ToString();
			usercount++;
			User user = new User();
			user.FirstName = id;
			user.LastName = id;
			user.Login = id;
			user.Administrator = false;
			user.Email = id + "@example.com";
			user.Update();
			users.Add(user);
			return user;
		}

		private MemberUserGroup GetTempMemberUserGroup()
		{
			string id = "test" + usercount.ToString();
			usercount++;
			MemberUserGroup g = new MemberUserGroup();
			g.Title	= id;
			g.Update();
			usergroups.Add(g);
			return g;
		}

		[Test]
		public void TestUserHasPrivilegeOnAny()
		{
			User user = GetTempUser();
			Collection coll = GetTempCollection();
			IAccessControl ac = coll.GetAccessControl();
			
			ac.AddUserPrivilege(Privilege.ManageCollection, Privilege.DeleteCollection, user.ID);

			Assert.IsTrue(User.HasPrivilege(Privilege.ManageCollection, coll, user));
			Assert.IsFalse(User.HasPrivilege(Privilege.DeleteCollection, coll, user));

			Assert.IsTrue(User.HasPrivilegeOnAny('C', user, Privilege.ManageCollection));
			Assert.IsFalse(User.HasPrivilegeOnAny('C', user, Privilege.DeleteCollection));

			// this should be true since only one of the privileges needs to be allowed
			Assert.IsTrue(User.HasPrivilegeOnAny('C', user, 
				Privilege.ManageCollection, Privilege.DeleteCollection));
		}

		[Test]
		public void TestGroupHasPrivilegeOnAny()
		{
			User user = GetTempUser();
			MemberUserGroup group = GetTempMemberUserGroup();
			group.Add(user);
			Collection coll = GetTempCollection();
			IAccessControl ac = coll.GetAccessControl();
			
			ac.AddUserGroupPrivilege(Privilege.ManageCollection, Privilege.DeleteCollection, group.ID);

			Assert.IsTrue(User.HasPrivilege(Privilege.ManageCollection, coll, user));
			Assert.IsFalse(User.HasPrivilege(Privilege.DeleteCollection, coll, user));

			Assert.IsTrue(User.HasPrivilegeOnAny('C', user, Privilege.ManageCollection));
			Assert.IsFalse(User.HasPrivilegeOnAny('C', user, Privilege.DeleteCollection));

			// this should be true since only one of the privileges needs to be allowed
			Assert.IsTrue(User.HasPrivilegeOnAny('C', user, 
				Privilege.ManageCollection, Privilege.DeleteCollection));
		}

	}
}
