namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;

	public class UserGroupSelection : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Repeater FirstLetterRepeater;

		private Orciid.Core.UserGroup[] currentusergroups = null;
		private int[] datasource = null;
		private ArrayList selected;
		protected System.Web.UI.WebControls.DataGrid UserGroupDataGrid;
		private int[] usergroupids;

		public int[] DataSource
		{
			set
			{
				datasource = value;
			}
		}

		public int[] GetSelection()
		{
			return (int[])selected.ToArray(typeof(int));
		}

		public override void DataBind()
		{
			base.DataBind();
			string[] patterns = Orciid.Core.UserGroup.GetTitlePatterns(1);
			FirstLetterRepeater.DataSource = patterns;
			FirstLetterRepeater.DataBind();
			if (patterns != null && patterns.Length > 0)
				QueryUserGroups(patterns[0]);
			else
				usergroupids = new int[0];
			selected = new ArrayList();
			if (datasource != null)
				selected.AddRange(datasource);
			UserGroupDataGrid.CurrentPageIndex = 0;
			BindGrid();
		}

		private void QueryUserGroups(string filter)
		{
			Orciid.Core.UserGroup[] usergroups = Orciid.Core.UserGroup.GetByTitlePattern(filter);
			usergroupids = new int[usergroups.Length];
			for (int i = 0; i < usergroups.Length; i++)
				usergroupids[i] = usergroups[i].ID;
			currentusergroups = new Orciid.Core.UserGroup[Math.Min(UserGroupDataGrid.PageSize, usergroups.Length)];
			for (int i = 0; i < currentusergroups.Length; i++)
				currentusergroups[i] = usergroups[i];
		}

		private void BindGrid()
		{
			//Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			Orciid.Core.UserGroup[] usergroups;
			
			UserGroupDataGrid.AllowPaging = (usergroupids.Length > UserGroupDataGrid.PageSize);	
			UserGroupDataGrid.VirtualItemCount = usergroupids.Length;
			if (currentusergroups != null)
				usergroups = currentusergroups;
			else if (usergroupids.Length == 0)
				usergroups = new Orciid.Core.UserGroup[0];
			else
			{
				int count = (UserGroupDataGrid.CurrentPageIndex < UserGroupDataGrid.PageCount - 1 ?
					UserGroupDataGrid.PageSize : 
					usergroupids.Length - (UserGroupDataGrid.PageCount - 1) * UserGroupDataGrid.PageSize);
				int[] a = new int[count];
				Array.Copy(usergroupids, UserGroupDataGrid.PageSize * UserGroupDataGrid.CurrentPageIndex, a, 0, count);
				usergroups = Orciid.Core.UserGroup.GetByID(a);
			}

			if (usergroups.Length == 0)
				UserGroupDataGrid.Visible = false;
			else
			{
				UserGroupDataGrid.Visible = true;
				UserGroupDataGrid.DataSource = usergroups;
				UserGroupDataGrid.DataBind();
			}
		}

		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				selected = ViewState["selected"] as ArrayList;
				usergroupids = (int[])ViewState["usergroupids"];
			}
		}

		protected override object SaveViewState()
		{
			ViewState["selected"] = selected;
			ViewState["usergroupids"] = usergroupids;
			return base.SaveViewState();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.FirstLetterRepeater.ItemCommand += new System.Web.UI.WebControls.RepeaterCommandEventHandler(this.FirstLetterRepeater_ItemCommand);
			this.UserGroupDataGrid.PageIndexChanged += new System.Web.UI.WebControls.DataGridPageChangedEventHandler(this.UserGroupDataGrid_PageIndexChanged);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void FirstLetterRepeater_ItemCommand(object source, System.Web.UI.WebControls.RepeaterCommandEventArgs e)
		{
			QueryUserGroups((string)e.CommandArgument);
			UserGroupDataGrid.CurrentPageIndex = 0;
			BindGrid();
		}

		private void UserGroupDataGrid_PageIndexChanged(object source, System.Web.UI.WebControls.DataGridPageChangedEventArgs e)
		{
			UserGroupDataGrid.CurrentPageIndex = e.NewPageIndex;
			BindGrid();
		}

		private DataGridItem GetDataGridItem(Control control)
		{
			while (!(control is DataGridItem) && control.Parent != null)
				control = control.Parent;
			return control as DataGridItem;
		}

		protected void DataBindSelectCheckBox(object sender, System.EventArgs e)
		{
			if (selected == null)
				return;
			CheckBox control = sender as CheckBox;
			DataGridItem item = GetDataGridItem(control);
			control.Checked = (selected.Contains(((Orciid.Core.UserGroup)item.DataItem).ID));
		}

		protected void CheckedChangedSelectedCheckBox(object sender, System.EventArgs e)
		{
			if (selected == null)
				return;
			CheckBox control = sender as CheckBox;
            DataGridItem item = GetDataGridItem(control);
			if (control.Checked)
				selected.Add(usergroupids[item.ItemIndex + UserGroupDataGrid.CurrentPageIndex * UserGroupDataGrid.PageSize]);
			else
				selected.Remove(usergroupids[item.ItemIndex + UserGroupDataGrid.CurrentPageIndex * UserGroupDataGrid.PageSize]);
		}
	}
}
