<%@ Control Language="c#" AutoEventWireup="false" Codebehind="UserSelection.ascx.cs" Inherits="Orciid.UserControls.UserSelection" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<p><asp:linkbutton ID="OrderByName" OnClick="OrderByName_Click" runat="server">Sort Users by Surname</asp:linkbutton> | 
	<asp:linkbutton ID="OrderByLogin" OnClick="OrderByLogin_Click" runat="server">Sort Users by Login</asp:linkbutton>
</p>
<p><asp:repeater ID="FirstLetterRepeater" runat="server">
		<itemtemplate>
			<asp:linkbutton CommandName="jumpto" CommandArgument="<%# Container.DataItem %>" runat="server">
				<%# Container.DataItem %>
			</asp:linkbutton>
		</itemtemplate>
		<separatortemplate>
			<img height="10" src="images/separator.gif" width="10">
		</separatortemplate>
	</asp:repeater></p>
<p><asp:datagrid ID="UserDataGrid" runat="server" AllowCustomPaging="True" AutoGenerateColumns="False"
		PageSize="20" AllowPaging="True" CellPadding="4" BorderWidth="1px" GridLines="Vertical" BorderColor="#DCE4EC"
		ShowFooter="True">
		<alternatingitemstyle CssClass="DataGridItemAlt" VerticalAlign="Top"></alternatingitemstyle>
		<itemstyle CssClass="DataGridItem" VerticalAlign="Top"></itemstyle>
		<headerstyle Wrap="False" HorizontalAlign="Left" CssClass="DataGridHeader"></headerstyle>
		<footerstyle Wrap="False" HorizontalAlign="Left" CssClass="DataGridFooter"></footerstyle>
		<columns>
			<asp:templatecolumn>
				<headertemplate>
					<input class="SelectBox" type="checkbox" name="changeall" onClick="var e=this.form.elements;for(var i=0;i<e.length;i++){var n=e[i].name;if(n.length>15&&n.substring(n.length-15,n.length)==':SelectCheckBox')e[i].checked=this.checked;}" />
				</headertemplate>
				<itemtemplate>
					<asp:checkbox ID="SelectCheckBox" runat="server" CssClass="SelectBox" OnDataBinding="DataBindSelectCheckBox"
						OnCheckedChanged="CheckedChangedSelectedCheckBox"></asp:checkbox>
				</itemtemplate>
			</asp:templatecolumn>
			<asp:boundcolumn DataField="Login" HeaderText="Login">
				<itemstyle Wrap="False"></itemstyle>
			</asp:boundcolumn>
			<asp:templatecolumn HeaderText="Name">
				<itemtemplate>
					<asp:label ID="FullNameLabel" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.FullName") %>'>
					</asp:label>
				</itemtemplate>
			</asp:templatecolumn>
			<asp:boundcolumn DataField="Email" HeaderText="Email">
				<itemstyle Wrap="False"></itemstyle>
			</asp:boundcolumn>
		</columns>
		<pagerstyle HorizontalAlign="Right" Wrap="False" Mode="NumericPages"></pagerstyle>
	</asp:datagrid></p>
